/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractJXPathModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.forrest.conf.AntProperties;

public class AntPropertiesModule
extends AbstractJXPathModule
implements InputModule,
Serviceable,
Configurable,
ThreadSafe {
    private SourceResolver m_resolver;
    private Properties m_properties;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        String file = configuration.getChild("file").getAttribute("src");
        this.load(file);
    }

    protected void load(String file) throws ConfigurationException {
        Source source = null;
        InputStream in = null;
        try {
            source = this.m_resolver.resolveURI(file);
            in = source.getInputStream();
            this.m_properties = new AntProperties();
            this.m_properties.load(in);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot load properties file " + file);
        }
        finally {
            if (source != null) {
                this.m_resolver.release(source);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Object getContextObject(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.m_properties;
    }
}

