/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.DefaultsModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.forrest.conf.AntProperties;
import org.apache.forrest.conf.ForrestConfUtils;

public class ForrestConfModule
extends DefaultsModule
implements InputModule,
Initializable,
ThreadSafe,
Serviceable {
    private AntProperties filteringProperties;
    private String forrestHome;
    private String projectHome;
    private String contextHome;
    private SourceResolver m_resolver;
    private static final String defaultHome = "context:/";

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String original = super.getAttributeValues(name, modeConf, objectModel)[0].toString();
        String attributeValue = this.getAttributeValues(name, modeConf, objectModel)[0].toString();
        if (this.debugging()) {
            this.debug(" - Requested:" + name);
        }
        if (this.debugging()) {
            this.debug(" - Unfiltered:" + original);
        }
        if (this.debugging()) {
            this.debug(" - Given:" + attributeValue);
        }
        return attributeValue;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] attributeValues = super.getAttributeValues(name, modeConf, objectModel);
        int i = 0;
        while (i < attributeValues.length) {
            attributeValues[i] = this.filteringProperties.filter(attributeValues[i].toString());
            ++i;
        }
        return attributeValues;
    }

    private final String getSystemProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName, defaultHome);
        if (this.debugging()) {
            this.debug("system property " + propertyName + "=" + propertyValue);
        }
        return propertyValue;
    }

    public void initialize() throws Exception {
        this.forrestHome = ForrestConfUtils.getForrestHome();
        this.projectHome = ForrestConfUtils.getProjectHome();
        this.contextHome = ForrestConfUtils.getContextHome();
        this.filteringProperties = new AntProperties();
        this.filteringProperties.setProperty("forrest.home", this.forrestHome);
        this.filteringProperties.setProperty("project.home", this.projectHome);
        this.filteringProperties.setProperty("context.home", this.contextHome);
        String forrestPropertiesStringURI = this.projectHome + SystemUtils.FILE_SEPARATOR + "forrest.properties";
        this.filteringProperties = this.loadAntPropertiesFromURI(this.filteringProperties, forrestPropertiesStringURI);
        String defaultForrestPropertiesStringURI = this.contextHome + SystemUtils.FILE_SEPARATOR + "default-forrest.properties";
        this.filteringProperties = this.loadAntPropertiesFromURI(this.filteringProperties, defaultForrestPropertiesStringURI);
        this.loadSystemProperties(this.filteringProperties);
        ForrestConfUtils.aliasSkinProperties(this.filteringProperties);
        if (this.debugging()) {
            this.debug("Loaded project forrest.properties:" + this.filteringProperties);
        }
    }

    private void loadSystemProperties(AntProperties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String systemPropValue = System.getProperty(propName);
            if (systemPropValue == null) continue;
            props.remove(propName);
            props.setProperty(propName, systemPropValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AntProperties loadAntPropertiesFromURI(AntProperties precedingProperties, String antPropertiesStringURI) throws MalformedURLException, IOException, SourceNotFoundException {
        Source source = null;
        InputStream in = null;
        try {
            source = this.m_resolver.resolveURI(antPropertiesStringURI);
            if (this.debugging()) {
                this.debug("Searching for forrest.properties in" + source.getURI());
            }
            in = source.getInputStream();
            this.filteringProperties = new AntProperties(precedingProperties);
            this.filteringProperties.load(in);
            if (this.debugging()) {
                this.debug("Loaded:" + antPropertiesStringURI + this.filteringProperties.toString());
            }
        }
        finally {
            if (source != null) {
                this.m_resolver.release(source);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return this.filteringProperties;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    private final boolean debugging() {
        return this.getLogger().isDebugEnabled();
    }

    private final void debug(String debugString) {
        this.getLogger().debug(debugString);
    }
}

