/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.conf;

import org.apache.commons.lang.SystemUtils;
import org.apache.forrest.conf.AntProperties;

public class ForrestConfUtils {
    public static final String defaultHome = "context:/";

    private static final String getSystemProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName, defaultHome);
        return propertyValue;
    }

    public static String getForrestHome() throws Exception {
        return ForrestConfUtils.getSystemProperty("forrest.home");
    }

    public static String getProjectHome() throws Exception {
        String projectHome = ForrestConfUtils.getSystemProperty("project.home");
        if (projectHome.equals(defaultHome)) {
            projectHome = defaultHome + SystemUtils.FILE_SEPARATOR + "/project";
        }
        return projectHome;
    }

    public static String getContextHome() throws Exception {
        String forrestHome = ForrestConfUtils.getForrestHome();
        String contextHome = forrestHome.equals(defaultHome) ? defaultHome : forrestHome + SystemUtils.FILE_SEPARATOR + "main/webapp";
        return contextHome;
    }

    public static void aliasSkinProperties(AntProperties props) {
        String skinName = props.getProperty("project.skin");
        if (skinName.equals("crust")) {
            ForrestConfUtils.setSkinToUse(props, "krysalis-site");
        } else if (skinName.equals("avalon-tigris") || skinName.equals("tigris-style")) {
            ForrestConfUtils.setSkinToUse(props, "tigris");
        } else if (skinName.equals("forrest-css")) {
            ForrestConfUtils.setSkinToUse(props, "pelt");
        }
    }

    private static void setSkinToUse(AntProperties props, String skinStoUse) {
        props.remove("project.skin");
        props.setProperty("project.skin", skinStoUse);
    }
}

