/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.modules.input.InputModule;

public abstract class AbstractWrappingModule
extends AbstractLogEnabled
implements InputModule,
Configurable,
Serviceable,
Disposable {
    InputModule child;
    ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration childConf = config.getChild("component-instance");
        String childClassName = childConf.getAttribute("class");
        this.getLogger().debug("Loading wrapped class:" + childClassName);
        try {
            this.child = (InputModule)Class.forName(childClassName).newInstance();
            this.getLogger().debug("Wrapped class instantiated:" + this.child);
            if (this.child instanceof LogEnabled) {
                ((LogEnabled)this.child).enableLogging(this.getLogger());
                this.getLogger().debug("Wrapped class LogEnabled");
            }
            if (this.child instanceof Serviceable) {
                ((Serviceable)this.child).service(this.manager);
                this.getLogger().debug("Wrapped class Serviced");
            }
            if (this.child instanceof Configurable) {
                ((Configurable)this.child).configure(config.getChild("component-instance"));
                this.getLogger().debug("Wrapped class Configured");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot instatiate the wrapped Module of class:" + childClassName, (Throwable)e);
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.child.getAttribute(name, modeConf, objectModel);
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.child.getAttributeNames(modeConf, objectModel);
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.child.getAttributeValues(name, modeConf, objectModel);
    }

    public void dispose() {
        if (this.child instanceof Disposable) {
            ((Disposable)this.child).dispose();
        }
    }
}

