/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.forrest.locationmap.lm.LocationMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocationMapModule
extends AbstractLogEnabled
implements InputModule,
Serviceable,
Configurable,
Disposable,
ThreadSafe {
    private static final Iterator ATTNAMES = Collections.EMPTY_LIST.iterator();
    private ServiceManager m_manager;
    private SourceResolver m_resolver;
    private String m_src;
    private SourceValidity m_srcVal;
    private LocationMap m_lm;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_src = configuration.getChild("file").getAttribute("src");
    }

    public void dispose() {
        this.m_lm.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LocationMap getLocationMap() throws Exception {
        Source source = null;
        try {
            source = this.m_resolver.resolveURI(this.m_src);
            if (this.m_lm == null) {
                LocationMapModule locationMapModule = this;
                synchronized (locationMapModule) {
                    if (this.m_lm == null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("loading location map at " + this.m_src);
                        }
                        this.m_srcVal = source.getValidity();
                        this.m_lm = new LocationMap(this.m_manager);
                        this.m_lm.enableLogging(this.getLogger());
                        this.m_lm.build(this.loadConfiguration(source));
                    }
                }
            }
            SourceValidity valid = source.getValidity();
            if (this.m_srcVal != null && this.m_srcVal.isValid(valid) != 1) {
                LocationMapModule locationMapModule = this;
                synchronized (locationMapModule) {
                    if (this.m_srcVal != null && this.m_srcVal.isValid(valid) != 1) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("reloading location map at " + this.m_src);
                        }
                        this.m_srcVal = valid;
                        this.m_lm.dispose();
                        this.m_lm = new LocationMap(this.m_manager);
                        this.m_lm.enableLogging(this.getLogger());
                        this.m_lm.build(this.loadConfiguration(source));
                    }
                }
            }
            Object var6_7 = null;
            if (source == null) return this.m_lm;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (source == null) throw throwable;
            this.m_resolver.release(source);
            throw throwable;
        }
        this.m_resolver.release(source);
        return this.m_lm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Configuration loadConfiguration(Source source) throws ConfigurationException {
        Configuration configuration = null;
        SAXParser parser = null;
        try {
            try {
                parser = (SAXParser)this.m_manager.lookup(SAXParser.ROLE);
                NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
                parser.parse(new InputSource(source.getInputStream()), (ContentHandler)handler);
                configuration = handler.getConfiguration();
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to build LocationMap.", (Throwable)e);
            }
            catch (SAXException e) {
                throw new ConfigurationException("Unable to build LocationMap.", (Throwable)e);
            }
            catch (ServiceException e) {
                throw new ConfigurationException("Unable to build LocationMap.", (Throwable)e);
            }
            Object var8_6 = null;
            if (parser == null) return configuration;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (parser == null) throw throwable;
            this.m_manager.release((Object)parser);
            throw throwable;
        }
        this.m_manager.release((Object)parser);
        return configuration;
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        try {
            return this.getLocationMap().locate(name, objectModel);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Failure processing LocationMap.", (Throwable)e);
            return null;
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return null;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return new Object[]{this.getAttribute(name, modeConf, objectModel)};
    }
}

