/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap.lm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;

public abstract class AbstractNode
extends AbstractLogEnabled {
    protected final ServiceManager m_manager;
    private Map m_parameters;

    public AbstractNode(ServiceManager manager) {
        this.m_manager = manager;
    }

    public void build(Configuration configuration) throws ConfigurationException {
        this.m_parameters = this.getParameters(configuration);
    }

    private final Map getParameters(Configuration configuration) throws ConfigurationException {
        Configuration[] children = configuration.getChildren("parameter");
        if (children.length == 0) {
            return null;
        }
        HashMap<VariableResolver, VariableResolver> parameters = new HashMap<VariableResolver, VariableResolver>();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getAttribute("name");
            String value = children[i].getAttribute("value");
            try {
                parameters.put(VariableResolverFactory.getResolver((String)name, (ServiceManager)this.m_manager), VariableResolverFactory.getResolver((String)value, (ServiceManager)this.m_manager));
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + "' at " + children[i].getLocation();
                throw new ConfigurationException(msg, (Throwable)pe);
            }
            ++i;
        }
        return parameters;
    }

    protected final Parameters resolveParameters(InvokeContext context, Map om) throws PatternException {
        Parameters parameters = null;
        parameters = this.m_parameters != null ? VariableResolver.buildParameters((Map)this.m_parameters, (InvokeContext)context, (Map)om) : new Parameters();
        Map anchorMap = context.getMapByAnchor("lm");
        Iterator entries = anchorMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            parameters.setParameter("#lm:" + entry.getKey(), entry.getValue().toString());
        }
        return parameters;
    }

    public abstract String locate(Map var1, InvokeContext var2) throws Exception;
}

