/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap.lm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.DefaultServiceSelector;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.selection.Selector;
import org.apache.forrest.locationmap.lm.LocatorNode;

public final class LocationMap
extends AbstractLogEnabled {
    public static final String URI = "http://apache.org/forrest/locationmap/1.0";
    public static final String ANCHOR_NAME = "lm";
    public static final String HINT_KEY = "hint";
    public static final String HINT_PARAM = "#lm:hint";
    private LocationMapServiceManager m_manager;
    private String m_defaultMatcher;
    private String m_defaultSelector;
    private LocatorNode[] m_locatorNodes;

    public LocationMap(ServiceManager manager) {
        this.m_manager = new LocationMapServiceManager(manager);
    }

    public void build(Configuration configuration) throws ConfigurationException {
        String src;
        String name;
        int i;
        Configuration components = configuration.getChild("components");
        Configuration child = components.getChild("matchers", false);
        if (child != null) {
            DefaultServiceSelector matcherSelector = new DefaultServiceSelector();
            this.m_defaultMatcher = child.getAttribute("default");
            Configuration[] matchers = child.getChildren("matcher");
            i = 0;
            while (i < matchers.length) {
                name = matchers[i].getAttribute("name");
                src = matchers[i].getAttribute("src");
                Matcher matcher = (Matcher)this.createComponent(src, matchers[i]);
                matcherSelector.put((Object)name, (Object)matcher);
                ++i;
            }
            matcherSelector.makeReadOnly();
            if (!matcherSelector.isSelectable((Object)this.m_defaultMatcher)) {
                throw new ConfigurationException("Default matcher is not defined.");
            }
            this.m_manager.put(Matcher.ROLE + "Selector", matcherSelector);
        }
        if ((child = components.getChild("selectors", false)) != null) {
            DefaultServiceSelector selectorSelector = new DefaultServiceSelector();
            this.m_defaultSelector = child.getAttribute("default");
            Configuration[] selectors = child.getChildren("selector");
            i = 0;
            while (i < selectors.length) {
                name = selectors[i].getAttribute("name");
                src = selectors[i].getAttribute("src");
                Selector selector = (Selector)this.createComponent(src, selectors[i]);
                selectorSelector.put((Object)name, (Object)selector);
                ++i;
            }
            selectorSelector.makeReadOnly();
            if (!selectorSelector.isSelectable((Object)this.m_defaultSelector)) {
                throw new ConfigurationException("Default selector is not defined.");
            }
            this.m_manager.put(Selector.ROLE + "Selector", selectorSelector);
        }
        this.m_manager.makeReadOnly();
        Configuration[] children = configuration.getChildren("locator");
        this.m_locatorNodes = new LocatorNode[children.length];
        int i2 = 0;
        while (i2 < children.length) {
            this.m_locatorNodes[i2] = new LocatorNode(this, (ServiceManager)this.m_manager);
            this.m_locatorNodes[i2].enableLogging(this.getLogger());
            this.m_locatorNodes[i2].build(children[i2]);
            ++i2;
        }
    }

    private Object createComponent(String src, Configuration config) throws ConfigurationException {
        Object component = null;
        try {
            component = Class.forName(src).newInstance();
            ContainerUtil.enableLogging(component, (Logger)this.getLogger());
            if (config != null) {
                ContainerUtil.configure(component, (Configuration)config);
            }
            ContainerUtil.initialize(component);
        }
        catch (Exception e) {
            throw new ConfigurationException("Couldn't create object of type " + src, (Throwable)e);
        }
        return component;
    }

    public void dispose() {
        Iterator components = this.m_manager.getObjects();
        while (components.hasNext()) {
            ContainerUtil.dispose(components.next());
        }
        this.m_manager = null;
        this.m_locatorNodes = null;
    }

    public String locate(String hint, Map om) throws Exception {
        String location = null;
        InvokeContext context = new InvokeContext();
        Logger contextLogger = this.getLogger().getChildLogger("ctx");
        ContainerUtil.enableLogging((Object)context, (Logger)contextLogger);
        ContainerUtil.compose((Object)context, (ComponentManager)new WrapperComponentManager((ServiceManager)this.m_manager));
        ContainerUtil.service((Object)context, (ServiceManager)this.m_manager);
        HashMap<String, String> anchorMap = new HashMap<String, String>(2);
        anchorMap.put(HINT_KEY, hint);
        context.pushMap(ANCHOR_NAME, anchorMap);
        int i = 0;
        while (i < this.m_locatorNodes.length) {
            location = this.m_locatorNodes[i].locate(om, context);
            if (location != null) break;
            ++i;
        }
        ContainerUtil.dispose((Object)context);
        if (this.getLogger().isDebugEnabled() && location == null) {
            this.getLogger().debug("No location matched request with hint " + hint);
        }
        return location;
    }

    String getDefaultMatcher() {
        return this.m_defaultMatcher;
    }

    String getDefaultSelector() {
        return this.m_defaultSelector;
    }

    private static class LocationMapServiceManager
    extends DefaultServiceManager {
        LocationMapServiceManager(ServiceManager parent) {
            super(parent);
        }

        Iterator getObjects() {
            return super.getObjectMap().values().iterator();
        }
    }
}

