/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap.lm;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.forrest.locationmap.lm.AbstractNode;
import org.apache.forrest.locationmap.lm.LocationMap;
import org.apache.forrest.locationmap.lm.MatchNode;
import org.apache.forrest.locationmap.lm.SelectNode;

public final class LocatorNode
extends AbstractNode {
    private final LocationMap m_lm;
    private VariableResolver m_baseLocation;
    private AbstractNode[] m_nodes;

    public LocatorNode(LocationMap lm, ServiceManager manager) {
        super(manager);
        this.m_lm = lm;
    }

    public void build(Configuration configuration) throws ConfigurationException {
        super.build(configuration);
        String base = configuration.getAttribute("base", null);
        if (base != null) {
            try {
                this.m_baseLocation = VariableResolverFactory.getResolver((String)base, (ServiceManager)this.m_manager);
            }
            catch (PatternException e) {
                String message = "Illegal pattern syntax for locator attribute 'base' at " + configuration.getLocation();
                throw new ConfigurationException(message);
            }
        }
        Configuration[] children = configuration.getChildren();
        ArrayList<MatchNode> nodes = new ArrayList<MatchNode>(children.length);
        int i = 0;
        while (i < children.length) {
            AbstractNode node = null;
            if (children[i].getName().equals("match")) {
                node = new MatchNode(this, this.m_manager);
            } else if (children[i].getName().equals("select")) {
                node = new SelectNode(this, this.m_manager);
            } else {
                String message = "Illegal locator node child: " + children[i].getName();
                throw new ConfigurationException(message);
            }
            node.enableLogging(this.getLogger());
            ((AbstractNode)node).build(children[i]);
            nodes.add((MatchNode)node);
            ++i;
        }
        this.m_nodes = nodes.toArray(new AbstractNode[nodes.size()]);
    }

    public String locate(Map om, InvokeContext context) throws Exception {
        String base = null;
        if (this.m_baseLocation != null && (base = this.m_baseLocation.resolve(context, om)) != null && base.charAt(base.length() - 1) != '/') {
            base = base + "/";
        }
        int i = 0;
        while (i < this.m_nodes.length) {
            String location = this.m_nodes[i].locate(om, context);
            if (location != null) {
                if (base != null && base.length() != 0 && location.charAt(0) != '/' && SourceUtil.indexOfSchemeColon((String)location) == -1) {
                    location = base + location;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("located: " + location);
                }
                return location;
            }
            ++i;
        }
        return null;
    }

    String getDefaultMatcher() {
        return this.m_lm.getDefaultMatcher();
    }

    String getDefaultSelector() {
        return this.m_lm.getDefaultSelector();
    }
}

