/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.locationmap.lm;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.selection.Selector;
import org.apache.forrest.locationmap.lm.AbstractNode;
import org.apache.forrest.locationmap.lm.LocationNode;
import org.apache.forrest.locationmap.lm.LocatorNode;
import org.apache.forrest.locationmap.lm.MatchNode;

public final class SelectNode
extends AbstractNode {
    private final LocatorNode m_ln;
    private Selector m_selector;
    private String m_type;
    private AbstractNode[] m_nodes;

    public SelectNode(LocatorNode ln, ServiceManager manager) {
        super(manager);
        this.m_ln = ln;
    }

    public void build(Configuration configuration) throws ConfigurationException {
        super.build(configuration);
        this.m_type = configuration.getAttribute("type", this.m_ln.getDefaultSelector());
        try {
            ServiceSelector selectors = (ServiceSelector)this.m_manager.lookup(Selector.ROLE + "Selector");
            this.m_selector = (Selector)selectors.select((Object)this.m_type);
        }
        catch (ServiceException e) {
            String message = "Unable to get Selector of type " + this.m_type;
            throw new ConfigurationException(message, (Throwable)e);
        }
        Configuration[] children = configuration.getChildren();
        ArrayList<LocationNode> nodes = new ArrayList<LocationNode>(children.length);
        int i = 0;
        while (i < children.length) {
            AbstractNode node = null;
            String name = children[i].getName();
            if (name.equals("location")) {
                node = new LocationNode(this.m_ln, this.m_manager);
            } else if (name.equals("match")) {
                node = new MatchNode(this.m_ln, this.m_manager);
            } else if (name.equals("select")) {
                node = new SelectNode(this.m_ln, this.m_manager);
            } else if (!name.equals("parameter")) {
                String message = "Unknown select node child:" + name;
                throw new ConfigurationException(message);
            }
            if (node != null) {
                node.enableLogging(this.getLogger());
                ((AbstractNode)node).build(children[i]);
                nodes.add((LocationNode)node);
            }
            ++i;
        }
        this.m_nodes = nodes.toArray(new AbstractNode[nodes.size()]);
    }

    public String locate(Map om, InvokeContext context) throws Exception {
        Parameters parameters = this.resolveParameters(context, om);
        int i = 0;
        while (i < this.m_nodes.length) {
            String location = this.m_nodes[i].locate(om, context);
            if (this.m_selector.select(location, om, parameters)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("selected: " + location);
                }
                return location;
            }
            ++i;
        }
        return null;
    }
}

