/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.sourcetype;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.forrest.sourcetype.DocDeclRule;
import org.apache.forrest.sourcetype.DocumentElementRule;
import org.apache.forrest.sourcetype.ProcessingInstructionRule;
import org.apache.forrest.sourcetype.SourceInfo;
import org.apache.forrest.sourcetype.SourceTypeRule;

public class SourceType
implements Configurable {
    protected List rules = new ArrayList();
    protected String name;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.name = configuration.getAttribute("name");
        Configuration[] ruleConfs = configuration.getChildren();
        int i = 0;
        while (i < ruleConfs.length) {
            SourceTypeRule rule;
            if (ruleConfs[i].getName().equals("document-declaration")) {
                rule = new DocDeclRule();
            } else if (ruleConfs[i].getName().equals("processing-instruction")) {
                rule = new ProcessingInstructionRule();
            } else if (ruleConfs[i].getName().equals("w3c-xml-schema")) {
                rule = new ProcessingInstructionRule();
            } else if (ruleConfs[i].getName().equals("document-element")) {
                rule = new DocumentElementRule();
            } else {
                throw new ConfigurationException("Unsupported element " + ruleConfs[i].getName() + " at " + ruleConfs[i].getLocation());
            }
            rule.configure(ruleConfs[i]);
            this.rules.add(rule);
            ++i;
        }
    }

    public boolean matches(SourceInfo sourceInfo) {
        Iterator rulesIt = this.rules.iterator();
        boolean matches = true;
        while (rulesIt.hasNext()) {
            SourceTypeRule rule = (SourceTypeRule)rulesIt.next();
            boolean bl = matches = matches && rule.matches(sourceInfo);
            if (matches) continue;
            return false;
        }
        return matches;
    }

    public String getName() {
        return this.name;
    }
}

