/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.sourcetype;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.forrest.sourcetype.SourceInfo;
import org.apache.forrest.sourcetype.SourceType;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.pull.XMLEvent;
import org.cyberneko.pull.event.DoctypeDeclEvent;
import org.cyberneko.pull.event.ElementEvent;
import org.cyberneko.pull.event.ProcessingInstructionEvent;
import org.cyberneko.pull.parsers.Xerces2;

public class SourceTypeAction
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Action {
    protected List sourceTypes = new ArrayList();
    protected static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] sourceTypeConfs = configuration.getChildren("sourcetype");
        int i = 0;
        while (i < sourceTypeConfs.length) {
            SourceType sourceType = new SourceType();
            sourceType.configure(sourceTypeConfs[i]);
            this.sourceTypes.add(sourceType);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String src, Parameters parameters) throws Exception {
        if (src == null || src.equals("")) {
            throw new Exception("SourceTypeAction: src attribute should be defined and non-empty.");
        }
        Source source = sourceResolver.resolveURI(src);
        Xerces2 parser = new Xerces2();
        try {
            InputStream is = source.getInputStream();
            parser.setInputSource(new XMLInputSource(null, src, null, is, null));
        }
        catch (SourceNotFoundException e) {
            this.getLogger().warn("Source '" + source + "' not found");
            return null;
        }
        parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SourceInfo sourceInfo = new SourceInfo();
        try {
            XMLEvent event;
            while ((event = parser.nextEvent()) != null) {
                void var9_10;
                if (var9_10.type == 9) {
                    DoctypeDeclEvent doctypeDeclEvent = (DoctypeDeclEvent)var9_10;
                    sourceInfo.setPublicId(doctypeDeclEvent.pubid);
                    continue;
                }
                if (var9_10.type == 6) {
                    ProcessingInstructionEvent piEvent = (ProcessingInstructionEvent)var9_10;
                    sourceInfo.addProcessingInstruction(piEvent.target, piEvent.data != null ? piEvent.data.toString() : null);
                    continue;
                }
                if (var9_10.type != 1) continue;
                ElementEvent elementEvent = (ElementEvent)var9_10;
                sourceInfo.setDocumentElementLocalName(elementEvent.element.localpart);
                sourceInfo.setDocumentElementNamespace(elementEvent.element.uri);
                sourceInfo.setXsiSchemaLocation(elementEvent.attributes.getValue(XSI_NAMESPACE, "schemaLocation"));
                sourceInfo.setXsiNoNamespaceSchemaLocation(elementEvent.attributes.getValue(XSI_NAMESPACE, "noNamespaceSchemaLocation"));
                break;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            parser.cleanup();
            throw throwable;
        }
        parser.cleanup();
        Iterator sourceTypeIt = this.sourceTypes.iterator();
        while (sourceTypeIt.hasNext()) {
            SourceType sourceType = (SourceType)sourceTypeIt.next();
            if (!sourceType.matches(sourceInfo)) continue;
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("sourcetype", sourceType.getName());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SourceTypeAction: found sourcetype " + sourceType.getName() + " for source " + src);
            }
            return returnMap;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SourceTypeAction: found no sourcetype for source " + src);
        }
        return null;
    }
}

