/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.sourcetype;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.forrest.sourcetype.SourceInfo;
import org.apache.forrest.sourcetype.SourceTypeRule;

public class XmlSchemaRule
implements SourceTypeRule {
    protected String schemaLocation;
    protected String noNamespaceSchemaLocation;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.schemaLocation = configuration.getAttribute("schema-location", null);
        this.noNamespaceSchemaLocation = configuration.getAttribute("no-namespace-schema-location", null);
        if (this.schemaLocation == null && this.noNamespaceSchemaLocation == null) {
            throw new ConfigurationException("Missing schema-location and/or no-namespace-schema-location attribute on w3c-xml-schema element at " + configuration.getLocation());
        }
    }

    public boolean matches(SourceInfo sourceInfo) {
        if (this.schemaLocation != null && this.noNamespaceSchemaLocation != null && this.schemaLocation.equals(sourceInfo.getXsiSchemaLocation()) && this.noNamespaceSchemaLocation.equals(sourceInfo.getXsiNoNamespaceSchemaLocation())) {
            return true;
        }
        if (this.schemaLocation != null && this.noNamespaceSchemaLocation == null && this.schemaLocation.equals(sourceInfo.getXsiSchemaLocation())) {
            return true;
        }
        return this.schemaLocation == null && this.noNamespaceSchemaLocation != null && this.noNamespaceSchemaLocation.equals(sourceInfo.getXsiNoNamespaceSchemaLocation());
    }
}

