/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractDOMTransformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IdGeneratorTransformer
extends AbstractDOMTransformer
implements CacheableProcessingComponent,
Configurable,
Disposable {
    private XPathProcessor processor = null;
    protected String elementXPath = null;
    protected String idXPath = null;
    protected String idAttr = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getLogger().info("## || Configuring IdGeneratorTransformer with " + configuration);
        this.elementXPath = configuration.getChild("element").getValue(null);
        this.idXPath = configuration.getChild("id").getValue(null);
        this.idAttr = configuration.getChild("id-attr").getValue("id");
        if (this.elementXPath == null) {
            throw new ConfigurationException("## The IdGenerator 'element' parameter must be specified. For example, <element>/document/body//*[local-name() = 'section']</element>");
        }
        if (this.idXPath == null) {
            throw new ConfigurationException("## The IdGenerator 'id' parameter must be specified. For example,<id>title/text()</id>");
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        try {
            this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain XPathProcessor", (Throwable)e);
        }
    }

    protected Document transform(Document doc) {
        this.getLogger().debug("## Transforming with element='" + this.elementXPath + "', id='" + this.idXPath + "'");
        Document newDoc = null;
        try {
            newDoc = this.addIds(doc, this.elementXPath, this.idXPath);
        }
        catch (SAXException se) {
            this.getLogger().error("Error when transforming XML: " + se.getMessage(), (Throwable)se.getException());
            throw new RuntimeException("Error transforming XML. See error log for details: " + se.getMessage() + ". Nested exception: " + se.getException().getMessage());
        }
        return newDoc;
    }

    private Document addIds(Document doc, String elementXPath, String idXPath) throws SAXException {
        this.getLogger().debug("## Using element XPath " + elementXPath);
        NodeList sects = this.processor.selectNodeList((Node)doc, elementXPath);
        this.getLogger().debug("## .. got " + sects.getLength() + " sections");
        int i = 0;
        while (i < sects.getLength()) {
            Element sect = (Element)sects.item(i);
            if (!sect.hasAttribute(this.idAttr)) {
                String newId;
                sect.normalize();
                this.getLogger().debug("## Using id XPath " + idXPath);
                String id = null;
                try {
                    id = this.processor.evaluateAsString((Node)sect, idXPath).trim();
                }
                catch (Exception e) {
                    throw new SAXException("'id' XPath expression '" + idXPath + "' does not return a text node: " + e, e);
                }
                this.getLogger().info("## Got id " + id);
                try {
                    newId = URLEncoder.encode(id, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.getLogger().error("cannot encode Id, using generate-id instead...", (Throwable)e);
                    newId = this.processor.evaluateAsString((Node)sect, "generate-id()");
                }
                newId = this.avoidConflicts(doc, sect, this.idAttr, newId);
                sect.setAttributeNS(sect.getNamespaceURI(), this.idAttr, newId);
            }
            ++i;
        }
        return doc;
    }

    private String avoidConflicts(Document doc, Element sect, String idAttr, String newId) {
        NodeList conflicts = this.processor.selectNodeList((Node)doc, "//*[@" + idAttr + "='" + newId + "']");
        int numConflicts = conflicts.getLength();
        this.getLogger().info("## " + numConflicts + " conflicts with " + newId);
        if (numConflicts != 0) {
            newId = newId + "-" + this.processor.evaluateAsString((Node)sect, "generate-id()");
        }
        return newId;
    }

    public Serializable getKey() {
        return "" + HashUtil.hash((String)(this.elementXPath + this.idXPath));
    }

    public Serializable generateKey() {
        return this.getKey();
    }

    public SourceValidity getValidity() {
        return new NOPValidity();
    }

    public SourceValidity generateValidity() {
        return this.getValidity();
    }

    public void recycle() {
        super.recycle();
    }

    public void dispose() {
        super.dispose();
        this.processor = null;
        this.elementXPath = null;
        this.idXPath = null;
        this.idAttr = null;
    }
}

