/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractDOMTransformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathTransformer
extends AbstractDOMTransformer
implements CacheableProcessingComponent {
    private XPathProcessor processor = null;
    private DOMParser parser = null;
    protected String include = null;
    protected String exclude = null;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.include = parameters.getParameter("include", "/");
        this.exclude = parameters.getParameter("exclude", null);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        try {
            this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain XPathProcessor", (Throwable)e);
        }
        try {
            this.parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain DOMParser", (Throwable)e);
        }
    }

    protected Document transform(Document doc) {
        this.getLogger().debug("Transforming with include='" + this.include + "', exclude='" + this.exclude + "'");
        Document newDoc = null;
        try {
            newDoc = this.handleIncludes(doc, this.include);
            newDoc = this.handleExcludes(newDoc, this.exclude);
        }
        catch (SAXException se) {
            this.getLogger().error("Error when transforming XML", (Throwable)se);
            throw new RuntimeException("Error transforming XML. See error log for details: " + se);
        }
        return newDoc;
    }

    private Document handleIncludes(Document doc, String xpath) throws SAXException {
        if (xpath == null || xpath.equals("/")) {
            return doc;
        }
        Document newDoc = this.parser.createDocument();
        NodeList nodes = this.processor.selectNodeList((Node)doc, xpath);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            this.addNode(newDoc, node);
            ++i;
        }
        return newDoc;
    }

    private Document handleExcludes(Document doc, String xpath) {
        if (xpath == null || xpath.trim().equals("")) {
            return doc;
        }
        NodeList nodes = this.processor.selectNodeList((Node)doc, xpath);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 2) {
                Attr attrNode = (Attr)node;
                Element parent = attrNode.getOwnerElement();
                parent.removeAttributeNode(attrNode);
            } else {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(node);
                }
            }
            ++i;
        }
        return doc;
    }

    private void addNode(Document doc, Node nodeTemplate) {
        Stack<Node> stack = new Stack<Node>();
        Node parent = nodeTemplate;
        Document oldDoc = nodeTemplate.getOwnerDocument();
        while (parent != oldDoc) {
            stack.push(parent);
            parent = parent.getParentNode();
        }
        parent = doc;
        while (!stack.empty()) {
            Node oldNode = (Node)stack.pop();
            Node newNode = null;
            if (!stack.empty()) {
                newNode = doc.importNode(oldNode, false);
                this.copyNamespaceDeclarations(oldNode, newNode);
                parent = this.findOrCreateNode(parent, newNode);
                continue;
            }
            newNode = doc.importNode(oldNode, true);
            this.copyNamespaceDeclarations(oldNode, newNode);
            parent.appendChild(newNode);
        }
    }

    private void copyNamespaceDeclarations(Node oldNode, Node newNode) {
        if (newNode.getNodeType() == 1) {
            String prefix = oldNode.getPrefix();
            String nsURI = oldNode.getNamespaceURI();
            Element newElem = (Element)newNode;
            if (nsURI != null) {
                if (prefix == null || prefix.equals("")) {
                    if (!newElem.hasAttribute("xmlns")) {
                        newElem.setAttribute("xmlns", nsURI);
                    }
                } else if (!newElem.hasAttribute("xmlns:" + prefix)) {
                    newElem.setAttribute("xmlns:" + prefix, nsURI);
                }
            }
        }
    }

    private Node findOrCreateNode(Node parent, Node newNode) {
        NodeList otherChildren = parent.getChildNodes();
        int i = 0;
        while (i < otherChildren.getLength()) {
            Node child = otherChildren.item(i);
            if (this.nodeEquality(child, newNode)) {
                return child;
            }
            ++i;
        }
        parent.appendChild(newNode);
        return newNode;
    }

    private boolean nodeEquality(Node n1, Node n2) {
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (n1.getNodeName() == null ? n2.getNodeName() != null : !n1.getNodeName().equals(n2.getNodeName())) {
            return false;
        }
        if (n1.getLocalName() == null ? n2.getLocalName() != null : !n1.getLocalName().equals(n2.getLocalName())) {
            return false;
        }
        if (n1.getNamespaceURI() == null ? n2.getNamespaceURI() != null : !n1.getNamespaceURI().equals(n2.getNamespaceURI())) {
            return false;
        }
        if (n1.getPrefix() == null ? n2.getPrefix() != null : !n1.getPrefix().equals(n2.getPrefix())) {
            return false;
        }
        return !(n1.getNodeValue() == null ? n2.getNodeValue() != null : !n1.getNodeValue().equals(n2.getNodeValue()));
    }

    private final void printNode(String msg, Node node) {
        this.getLogger().info(msg + " " + node.getNodeName());
    }

    public Serializable getKey() {
        return "" + HashUtil.hash((String)(this.include + this.exclude));
    }

    public Serializable generateKey() {
        return this.getKey();
    }

    public SourceValidity getValidity() {
        return new NOPValidity();
    }

    public SourceValidity generateValidity() {
        return this.getValidity();
    }

    public void recycle() {
        super.recycle();
        this.include = null;
        this.exclude = null;
    }

    public void dispose() {
        super.dispose();
        this.processor = null;
        this.parser = null;
        this.include = null;
        this.exclude = null;
    }
}

