/*
 * Decompiled with CFR 0.152.
 */
package org.apache.forrest.xni;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.EntityResolver;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XNIConfigurableFileGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent,
Recyclable {
    public static final String CONFIGCLASS_PARAMETER = "config-class";
    public static final String FULL_ENTITY_RESOLVER_PROPERTY_URI = "http://apache.org/xml/properties/internal/entity-resolver";
    private Source inputSource;
    XMLParserConfiguration parserConfig;

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        String parserName = null;
        try {
            this.inputSource = resolver.resolveURI(this.source);
            parserName = par.getParameter(CONFIGCLASS_PARAMETER);
            this.parserConfig = (XMLParserConfiguration)Class.forName(parserName).newInstance();
        }
        catch (ParameterException e) {
            this.getLogger().error("Missing parameter config-class", (Throwable)e);
            throw new ProcessingException("XNIConfigurable.setup()", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.getLogger().error("Can not make instance of " + parserName, (Throwable)e);
            throw new ProcessingException("XNIConfigurable.setup()", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().error("Can not access constructor of " + parserName, (Throwable)e);
            throw new ProcessingException("XNIConfigurable.setup()", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error("Can not find " + parserName, (Throwable)e);
            throw new ProcessingException("XNIConfigurable.setup()", (Throwable)e);
        }
        catch (SourceException e) {
            this.getLogger().error("Can not resolve " + this.source);
            throw SourceUtil.handle((String)("Unable to resolve " + this.source), (SourceException)e);
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public Serializable generateKey() {
        return this.getKey();
    }

    public SourceValidity getValidity() {
        if (this.inputSource.getLastModified() != 0L) {
            this.inputSource.getValidity();
        }
        return null;
    }

    public SourceValidity generateValidity() {
        return this.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        EntityResolver catalogResolver = null;
        String[] extendRecognizedProperties = new String[]{FULL_ENTITY_RESOLVER_PROPERTY_URI};
        try {
            try {
                this.getLogger().debug("XNIConfigurable generator start generate()");
                catalogResolver = (EntityResolver)this.manager.lookup(EntityResolver.ROLE);
                this.parserConfig.addRecognizedProperties(extendRecognizedProperties);
                this.parserConfig.setProperty(FULL_ENTITY_RESOLVER_PROPERTY_URI, (Object)new EntityResolverWrapper((org.xml.sax.EntityResolver)catalogResolver));
                AbstractSAXParser parser = new AbstractSAXParser(this.parserConfig){};
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                parser.setContentHandler(this.contentHandler);
                parser.parse(new InputSource(this.inputSource.getInputStream()));
            }
            catch (IOException e) {
                this.getLogger().warn("XNIConfigurable.generate()", (Throwable)e);
                throw new ResourceNotFoundException("Could not get resource to process:\n[src = " + this.inputSource.getURI() + "]\n", (Throwable)e);
            }
            catch (SAXException e) {
                this.getLogger().error("XNIConfigurable.generate()", (Throwable)e);
                throw e;
            }
            catch (XMLConfigurationException e) {
                this.getLogger().error("Misconfig " + e.getType(), (Throwable)e);
                throw new ProcessingException("XNIConfigurable.generate()", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error("Some strange thing just happened!!", (Throwable)e);
                throw new ProcessingException("XNIConfigurable.generate()", (Throwable)e);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.manager.release(catalogResolver);
            throw throwable;
        }
        this.manager.release((Object)catalogResolver);
    }
}

