/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.build.EndOfFile;
import net.sourceforge.chaperon.build.FirstSetCollection;
import net.sourceforge.chaperon.build.ItemSet;
import net.sourceforge.chaperon.build.ItemSetCollection;
import net.sourceforge.chaperon.build.conflict.ConflictList;
import net.sourceforge.chaperon.build.conflict.ReduceReduceConflict;
import net.sourceforge.chaperon.build.conflict.ShiftReduceConflict;
import net.sourceforge.chaperon.common.IntegerSet;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.grammar.Associativity;
import net.sourceforge.chaperon.model.grammar.Error;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;
import net.sourceforge.chaperon.process.ParserAutomaton;
import org.apache.commons.logging.Log;

public class ParserAutomatonBuilder {
    private static final EndOfFile EOF = new EndOfFile();
    private Grammar grammar;
    private SymbolSet tsymbols;
    private SymbolSet ntsymbols;
    private FirstSetCollection firstsets;
    private ItemSetCollection itemsets;
    private ParserAutomaton automaton;
    private ConflictList conflicts = new ConflictList();
    private Log log;

    public ParserAutomatonBuilder(Grammar grammar) {
        this(grammar, null);
    }

    public ParserAutomatonBuilder(Grammar grammar, Log log) {
        this.grammar = (Grammar)grammar.clone();
        this.log = log;
        Violations violations = grammar.validate();
        if (violations != null && violations.getViolationCount() > 0) {
            throw new IllegalArgumentException("Grammar is not valid: " + violations.getViolation(0));
        }
        SymbolSet symbols = grammar.getSymbols();
        this.tsymbols = symbols.getTerminals();
        this.ntsymbols = symbols.getNonterminals();
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)"Generating first sets");
        }
        this.firstsets = new FirstSetCollection(grammar, log);
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)this.firstsets.toString());
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)"Building states and transitions");
        }
        this.itemsets = new ItemSetCollection(grammar, this.firstsets, log);
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)this.itemsets.toString());
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)"Building parser automaton");
        }
        this.automaton = new ParserAutomaton(this.tsymbols.getSymbolCount(), this.ntsymbols.getSymbolCount(), grammar.getProductionCount(), 0, this.itemsets.getItemSetCount());
        int i = 0;
        while (i < this.tsymbols.getSymbolCount()) {
            this.automaton.setTerminal(i, this.tsymbols.getSymbol(i).getName());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ntsymbols.getSymbolCount()) {
            this.automaton.setNonterminal(i2, this.ntsymbols.getSymbol(i2).getName());
            ++i2;
        }
        int i3 = 0;
        while (i3 < grammar.getProductionCount()) {
            this.automaton.setProductionSymbol(i3, this.ntsymbols.indexOf(grammar.getProduction(i3).getSymbol()));
            this.automaton.setProductionLength(i3, grammar.getProduction(i3).getLength());
            ++i3;
        }
        int state = 0;
        while (state < this.itemsets.getItemSetCount()) {
            int k;
            int highestproduction;
            int productionpriority;
            IntegerSet reduceproductions;
            ItemSet I = this.itemsets.getItemSet(state);
            SymbolSet shiftsymbols = I.getShiftSymbols();
            SymbolSet reducesymbols = I.getReduceSymbols();
            int symbol = 0;
            while (symbol < this.tsymbols.getSymbolCount()) {
                block39: {
                    boolean errorreduce;
                    block36: {
                        block37: {
                            block42: {
                                Associativity associativity;
                                block41: {
                                    ShiftReduceConflict shiftconflict;
                                    block40: {
                                        int tokenpriority;
                                        block38: {
                                            reduceproductions = I.getReduceProductions(this.tsymbols.getSymbol(symbol));
                                            productionpriority = -1;
                                            highestproduction = -1;
                                            k = 0;
                                            while (k < reduceproductions.getCount()) {
                                                ReduceReduceConflict reduceconflict = null;
                                                if (k > 0) {
                                                    reduceconflict = new ReduceReduceConflict(grammar, this.itemsets, state, (Terminal)this.tsymbols.getSymbol(symbol), reduceproductions.get(k - 1), reduceproductions.get(k));
                                                    this.conflicts.addConflict(reduceconflict);
                                                    if (log != null) {
                                                        log.warn((Object)reduceconflict.toString());
                                                    }
                                                }
                                                if (grammar.getPriority(grammar.getProduction(reduceproductions.get(k))) > productionpriority) {
                                                    highestproduction = reduceproductions.get(k);
                                                    productionpriority = grammar.getPriority(grammar.getProduction(highestproduction));
                                                }
                                                ++k;
                                            }
                                            if (reduceproductions.getCount() > 1 && log != null && log.isInfoEnabled()) {
                                                log.info((Object)("The parser will reduce the production " + grammar.getProduction(highestproduction)));
                                            }
                                            errorreduce = reducesymbols.contains(Error.instance);
                                            if (!shiftsymbols.contains(this.tsymbols.getSymbol(symbol))) break block36;
                                            if (!errorreduce && !reducesymbols.contains(this.tsymbols.getSymbol(symbol))) break block37;
                                            tokenpriority = grammar.getPriority((Terminal)this.tsymbols.getSymbol(symbol));
                                            shiftconflict = new ShiftReduceConflict(grammar, this.itemsets, state, (Terminal)this.tsymbols.getSymbol(symbol), highestproduction);
                                            if (tokenpriority <= productionpriority) break block38;
                                            this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                                            if (log != null) {
                                                log.info((Object)shiftconflict.toString());
                                                log.info((Object)"The parser will shift");
                                            }
                                            break block39;
                                        }
                                        if (tokenpriority >= productionpriority) break block40;
                                        this.automaton.setReduceAction(state, symbol, highestproduction);
                                        if (log != null) {
                                            log.info((Object)shiftconflict.toString());
                                            log.info((Object)"The parser will reduce");
                                        }
                                        break block39;
                                    }
                                    if (log != null) {
                                        log.warn((Object)shiftconflict.toString());
                                    }
                                    if (!(associativity = grammar.getAssociativity((Terminal)this.tsymbols.getSymbol(symbol))).equals(Associativity.RIGHT)) break block41;
                                    this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                                    if (log != null) {
                                        log.warn((Object)"The parser will shift");
                                    }
                                    break block39;
                                }
                                if (!associativity.equals(Associativity.LEFT)) break block42;
                                this.automaton.setReduceAction(state, symbol, highestproduction);
                                if (log != null) {
                                    log.warn((Object)"The parser will reduce");
                                }
                                break block39;
                            }
                            this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                            if (log == null) break block39;
                            log.warn((Object)"The parser will shift");
                            break block39;
                        }
                        this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                        break block39;
                    }
                    if (errorreduce || reducesymbols.contains(this.tsymbols.getSymbol(symbol))) {
                        this.automaton.setReduceAction(state, symbol, highestproduction);
                    } else {
                        int i4 = 0;
                        while (i4 < shiftsymbols.getSymbolCount()) {
                            if (shiftsymbols.getSymbol(i4) instanceof Error) {
                                this.automaton.setErrorAction(state, symbol, I.getTransition(shiftsymbols.getSymbol(i4)));
                            }
                            ++i4;
                        }
                    }
                }
                ++symbol;
            }
            if (reducesymbols.contains(EOF)) {
                reduceproductions = I.getReduceProductions(EOF);
                productionpriority = -1;
                highestproduction = -1;
                k = 0;
                while (k < reduceproductions.getCount()) {
                    if (grammar.getPriority(grammar.getProduction(reduceproductions.get(k))) > productionpriority) {
                        highestproduction = reduceproductions.get(k);
                        productionpriority = grammar.getPriority(grammar.getProduction(highestproduction));
                    }
                    ++k;
                }
                if (grammar.getProduction(highestproduction).getSymbol().equals(grammar.getStartSymbol())) {
                    this.automaton.setAcceptAction(state, highestproduction);
                } else {
                    this.automaton.setReduceAction(state, highestproduction);
                }
            } else {
                int i5 = 0;
                while (i5 < shiftsymbols.getSymbolCount()) {
                    if (shiftsymbols.getSymbol(i5) instanceof Error) {
                        this.automaton.setErrorAction(state, I.getTransition(shiftsymbols.getSymbol(i5)));
                    }
                    ++i5;
                }
            }
            int symbol2 = 0;
            while (symbol2 < this.ntsymbols.getSymbolCount()) {
                if (shiftsymbols.contains(this.ntsymbols.getSymbol(symbol2))) {
                    this.automaton.setTransition(state, symbol2, I.getTransition(this.ntsymbols.getSymbol(symbol2)));
                }
                ++symbol2;
            }
            ++state;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("Parser automaton:\n" + this.automaton.toString()));
        }
    }

    public ParserAutomaton getParserAutomaton() {
        return this.automaton;
    }
}

