/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.util;

import com.opensymphony.util.ClassLoaderUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileManager {
    private static Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$util$FileManager == null ? (class$com$opensymphony$util$FileManager = FileManager.class$("com.opensymphony.util.FileManager")) : class$com$opensymphony$util$FileManager));
    private static Map files = Collections.synchronizedMap(new HashMap());
    protected static boolean reloadingConfigs = false;
    static /* synthetic */ Class class$com$opensymphony$util$FileManager;

    private FileManager() {
    }

    public static void setReloadingConfigs(boolean reloadingConfigs) {
        FileManager.reloadingConfigs = reloadingConfigs;
    }

    public static boolean isReloadingConfigs() {
        return reloadingConfigs;
    }

    public static boolean fileNeedsReloading(String fileName) {
        FileRevision revision = (FileRevision)files.get(fileName);
        if (revision == null) {
            return true;
        }
        return revision.getLastModified() < revision.getFile().lastModified();
    }

    public static InputStream loadFile(String fileName, Class clazz) {
        URL fileUrl = ClassLoaderUtil.getResource(fileName, clazz);
        if (fileUrl == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = fileUrl.openStream();
            if (is == null) {
                throw new Exception("Could not open file " + fileName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception while loading file " + fileName));
        }
        if (FileManager.isReloadingConfigs()) {
            File file = new File(fileUrl.getFile());
            long lastModified = 0L;
            if (!file.exists() || !file.canRead()) {
                file = null;
            }
            if (file != null) {
                lastModified = file.lastModified();
                files.put(fileName, new FileRevision(file, lastModified));
            }
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FileRevision {
        private File file;
        private long lastModified;

        public FileRevision(File file, long lastUpdated) {
            this.file = file;
            this.lastModified = lastUpdated;
        }

        public File getFile() {
            return this.file;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

