/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.ParseUtil;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.values.JavaDecimalHolder;
import org.apache.xmlbeans.impl.values.JavaLongHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaLongHolderEx
extends JavaLongHolder {
    private SchemaType _schemaType;

    public JavaLongHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    protected void set_text(String s) {
        long v;
        try {
            v = Long.parseLong(ParseUtil.trimInitialPlus(s));
        }
        catch (Exception e) {
            throw new XmlValueOutOfRangeException();
        }
        if (this._validateOnSet()) {
            JavaLongHolderEx.validateValue(v, this._schemaType, XmlObjectBase._voorVc);
            JavaLongHolderEx.validateLexical(s, this._schemaType, XmlObjectBase._voorVc);
        }
        super.set_long(v);
    }

    protected void set_long(long v) {
        if (this._validateOnSet()) {
            JavaLongHolderEx.validateValue(v, this._schemaType, XmlObjectBase._voorVc);
        }
        super.set_long(v);
    }

    public static void validateLexical(String v, SchemaType sType, ValidationContext context) {
        JavaDecimalHolder.validateLexical(v, context);
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v)) {
            context.invalid("Integer (" + v + ") does not match pattern for " + QNameHelper.readable(sType));
        }
    }

    private static void validateValue(long v, SchemaType sType, ValidationContext context) {
        long m;
        long m2;
        long m3;
        long m4;
        XmlAnySimpleType mine;
        XmlAnySimpleType td = sType.getFacet(7);
        if (td != null) {
            long m5 = JavaLongHolderEx.getLongValue(td);
            String temp = Long.toString(v);
            int len = temp.length();
            if (len > 0 && temp.charAt(0) == '-') {
                --len;
            }
            if ((long)len > m5) {
                context.invalid("Integer total digits (" + temp + ") is greater than " + "total digits facet (" + m5 + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((mine = sType.getFacet(3)) != null && v <= (m4 = JavaLongHolderEx.getLongValue(mine))) {
            context.invalid("Integer (" + v + ") is less than or equal to " + "min exclusive facet (" + m4 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType mini = sType.getFacet(4);
        if (mini != null && v < (m3 = JavaLongHolderEx.getLongValue(mini))) {
            context.invalid("Integer (" + v + ") is less than or equal to " + "min exclusive facet (" + m3 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxi = sType.getFacet(5);
        if (maxi != null && v > (m2 = JavaLongHolderEx.getLongValue(maxi))) {
            context.invalid("Integer (" + v + ") is less than " + "min inclusive facet (" + m2 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxe = sType.getFacet(6);
        if (maxe != null && v >= (m = JavaLongHolderEx.getLongValue(maxe))) {
            context.invalid("Integer (" + v + ") is greater than or equal to " + "max exclusive facet (" + m + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            int i = 0;
            while (i < vals.length) {
                if (v == JavaLongHolderEx.getLongValue(vals[i])) {
                    return;
                }
                ++i;
            }
            context.invalid("Integer (" + v + ") does not match any enumeration values for " + QNameHelper.readable(sType));
        }
    }

    private static long getLongValue(XmlObject o) {
        SchemaType s = o.schemaType();
        switch (s.getDecimalSize()) {
            case 1000001: {
                return ((XmlObjectBase)o).bigDecimalValue().longValue();
            }
            case 1000000: {
                return ((XmlObjectBase)o).bigIntegerValue().longValue();
            }
            case 64: {
                return ((XmlObjectBase)o).longValue();
            }
        }
        throw new IllegalStateException("Bad facet type: " + s);
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaLongHolderEx.validateLexical(lexical, this.schemaType(), ctx);
        JavaLongHolderEx.validateValue(this.longValue(), this.schemaType(), ctx);
    }
}

