/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.util.ArrayList;
import org.apache.cocoon.components.profiler.EnvironmentInfo;
import org.apache.cocoon.util.HashUtil;

public class ProfilerData {
    private ArrayList entries = new ArrayList();
    private EnvironmentInfo environmentinfo;
    private long totaltime = 0L;

    public void addComponent(Object component, String role, String source) {
        this.entries.add(new Entry(role != null ? role : component.getClass().getName(), source));
    }

    public int getCount() {
        return this.entries.size();
    }

    public void setEnvironmentInfo(EnvironmentInfo environmentinfo) {
        this.environmentinfo = environmentinfo;
    }

    public EnvironmentInfo getEnvironmentInfo() {
        return this.environmentinfo;
    }

    public void setTotalTime(long time) {
        this.totaltime = time;
    }

    public long getTotalTime() {
        return this.totaltime;
    }

    public void setSetupTime(int index, long time) {
        ((Entry)this.entries.get((int)index)).setup = time;
    }

    public long getSetupTime(int index) {
        return ((Entry)this.entries.get((int)index)).setup;
    }

    public void setProcessingTime(int index, long time) {
        ((Entry)this.entries.get((int)index)).time = time;
    }

    public long getProcessingTime(int index) {
        return ((Entry)this.entries.get((int)index)).time;
    }

    public void setSAXFragment(int index, Object fragment) {
        ((Entry)this.entries.get((int)index)).fragment = fragment;
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public long getKey(String uri) {
        StringBuffer key = new StringBuffer(uri);
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.get(i);
            key.append(':');
            key.append(entry.role);
            key.append(':');
            key.append(entry.source);
        }
        return HashUtil.hash((StringBuffer)key);
    }

    public class Entry {
        public String role;
        public String source;
        public long setup;
        public long time;
        public Object fragment;

        protected Entry(String role, String source) {
            this.role = role;
            this.source = source;
        }
    }
}

