/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.matching.PreparableMatcher;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.selection.SwitchSelector;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapExecutor;

public class SimpleSitemapExecutor
extends AbstractLogEnabled
implements ThreadSafe,
SitemapExecutor {
    public Map invokeAction(ExecutionContext context, Map objectModel, Action action, Redirector redirector, SourceResolver resolver, String resolvedSource, Parameters resolvedParams) throws Exception {
        this.getLogger().info("- Invoking action '" + context.getType() + "' (" + context.getLocation() + ").");
        Map result = action.act(redirector, resolver, objectModel, resolvedSource, resolvedParams);
        if (result != null) {
            this.getLogger().info("- Action '" + context.getType() + "' returned a map.");
        } else {
            this.getLogger().info("- Action '" + context.getType() + "' did not return a map.");
        }
        return result;
    }

    public Map invokeMatcher(ExecutionContext context, Map objectModel, Matcher matcher, String pattern, Parameters resolvedParams) throws PatternException {
        this.getLogger().info("- Invoking matcher '" + context.getType() + "' (" + context.getLocation() + ").");
        Map result = matcher.match(pattern, objectModel, resolvedParams);
        if (result != null) {
            this.getLogger().info("- Matcher '" + context.getType() + "' returned a map.");
        } else {
            this.getLogger().info("- Matcher '" + context.getType() + "' did not return a map.");
        }
        return result;
    }

    public Map invokePreparableMatcher(ExecutionContext context, Map objectModel, PreparableMatcher matcher, Object preparedPattern, Parameters resolvedParams) throws PatternException {
        this.getLogger().info("- Invoking matcher '" + context.getType() + "' (" + context.getLocation() + ").");
        Map result = matcher.preparedMatch(preparedPattern, objectModel, resolvedParams);
        if (result != null) {
            this.getLogger().info("- Matcher '" + context.getType() + "' returned a map.");
        } else {
            this.getLogger().info("- Matcher '" + context.getType() + "' did not return a map.");
        }
        return result;
    }

    public boolean invokeSelector(ExecutionContext context, Map objectModel, Selector selector, String expression, Parameters parameters) {
        this.getLogger().info("- Invoking selector '" + context.getType() + "' (" + context.getLocation() + ").");
        boolean result = selector.select(expression, objectModel, parameters);
        if (result) {
            this.getLogger().info("- Selector '" + context.getType() + "' succeeded.");
        } else {
            this.getLogger().info("- Selector '" + context.getType() + "' failed.");
        }
        return result;
    }

    public boolean invokeSwitchSelector(ExecutionContext context, Map objectModel, SwitchSelector selector, String expression, Parameters parameters, Object selectorContext) {
        this.getLogger().info("- Invoking selector '" + context.getType() + "' (" + context.getLocation() + ").");
        boolean result = selector.select(expression, selectorContext);
        if (result) {
            this.getLogger().info("- Selector '" + context.getType() + "' succeeded.");
        } else {
            this.getLogger().info("- Selector '" + context.getType() + "' failed.");
        }
        return result;
    }

    public void popVariables(ExecutionContext context, Map objectModel) {
        this.getLogger().info("- Variable Context ends");
    }

    public Map pushVariables(ExecutionContext context, Map objectModel, String key, Map variables) {
        this.getLogger().info("- New Variable Context: " + (key != null ? "('" + key + "')" : ""));
        Iterator keys = variables.entrySet().iterator();
        while (keys.hasNext()) {
            Map.Entry entry = keys.next();
            this.getLogger().info("   " + entry.getKey() + " : " + entry.getValue());
        }
        return variables;
    }

    public String enterSitemap(ExecutionContext context, Map objectModel, String source) {
        this.getLogger().info("- Entering sitemap " + source);
        return source;
    }

    public SitemapExecutor.PipelineComponentDescription addGenerator(ExecutionContext context, Map objectModel, SitemapExecutor.PipelineComponentDescription desc) {
        this.getLogger().info("- Adding generator '" + desc.type + "' (" + context.getLocation() + ").");
        return desc;
    }

    public SitemapExecutor.PipelineComponentDescription addReader(ExecutionContext context, Map objectModel, SitemapExecutor.PipelineComponentDescription desc) {
        this.getLogger().info("- Adding reader '" + desc.type + "' (" + context.getLocation() + ").");
        return desc;
    }

    public SitemapExecutor.PipelineComponentDescription addSerializer(ExecutionContext context, Map objectModel, SitemapExecutor.PipelineComponentDescription desc) {
        this.getLogger().info("- Adding serializer '" + desc.type + "' (" + context.getLocation() + ").");
        return desc;
    }

    public SitemapExecutor.PipelineComponentDescription addTransformer(ExecutionContext context, Map objectModel, SitemapExecutor.PipelineComponentDescription desc) {
        this.getLogger().info("- Adding transformer '" + desc.type + "' (" + context.getLocation() + ").");
        return desc;
    }
}

