/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.profiler.EnvironmentInfo;
import org.apache.cocoon.components.profiler.Profiler;
import org.apache.cocoon.components.profiler.ProfilerResult;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProfilerGenerator
extends ServiceableGenerator {
    private static final String PROFILER_NS = "http://apache.org/cocoon/profiler/1.0";
    private static final String PROFILERINFO_ELEMENT = "profilerinfo";
    private static final String RESULTS_ELEMENT = "pipeline";
    private static final String RESULT_ELEMENT = "result";
    private static final String AVERAGERESULT_ELEMENT = "average";
    private static final String ENVIROMENTINFO_ELEMENT = "environmentinfo";
    private static final String REQUESTPARAMETERS_ELEMENT = "request-parameters";
    private static final String REQUESTPARAMETER_ELEMENT = "parameter";
    private static final String SESSIONATTRIBUTES_ELEMENT = "session-attributes";
    private static final String SESSIONATTRIBUTE_ELEMENT = "attribute";
    private static final String COMPONENT_ELEMENT = "component";
    private static final String FRAGMENT_ELEMENT = "fragment";
    private static final String PREFIX = "profiler";
    private static final String PREFIX_COLON = "profiler:";
    private Profiler profiler;
    private Long key = null;
    private int resultIndex = -1;
    private int componentIndex = -1;
    private boolean fragmentOnly;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.profiler = (Profiler)this.manager.lookup(Profiler.ROLE);
    }

    public void setup(SourceResolver resolver, Map objectModel, String soure, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, this.source, parameters);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.key = request.getParameter("key") != null ? new Long(Long.parseLong(request.getParameter("key"))) : null;
        this.resultIndex = request.getParameter(RESULT_ELEMENT) != null && this.key != null ? Integer.parseInt(request.getParameter(RESULT_ELEMENT)) : -1;
        this.componentIndex = request.getParameter(COMPONENT_ELEMENT) != null && this.resultIndex != -1 ? Integer.parseInt(request.getParameter(COMPONENT_ELEMENT)) : -1;
        this.fragmentOnly = request.getParameter("fragmentonly") != null && request.getParameter("fragmentonly").equals("true");
    }

    public void dispose() {
        if (this.profiler != null) {
            this.manager.release((Object)this.profiler);
            this.profiler = null;
        }
        super.dispose();
    }

    public void generate() throws SAXException {
        if (this.fragmentOnly && this.key != null && this.resultIndex != -1 && this.componentIndex != -1) {
            Object fragment = null;
            try {
                ProfilerResult result = this.profiler.getResult(this.key);
                fragment = result.getSAXFragments()[this.resultIndex][this.componentIndex];
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fragment != null) {
                this.generateSAXFragment(fragment, false);
            } else {
                this.contentHandler.startDocument();
                this.contentHandler.startPrefixMapping(PREFIX, PROFILER_NS);
                this.contentHandler.startElement(PROFILER_NS, "fragment-error", "profiler:fragment-error", new AttributesImpl());
                char[] message = "Fragment is not available.".toCharArray();
                this.contentHandler.characters(message, 0, message.length);
                this.contentHandler.endElement(PROFILER_NS, "fragment-error", "profiler:fragment-error");
                this.contentHandler.endPrefixMapping(PREFIX);
                this.contentHandler.endDocument();
            }
        } else {
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(PREFIX, PROFILER_NS);
            this.generateProfilerInfo();
            this.contentHandler.endPrefixMapping(PREFIX);
            this.contentHandler.endDocument();
        }
    }

    private void generateProfilerInfo() throws SAXException {
        String dateTime = DateFormat.getDateTimeInstance().format(new Date());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "date", "date", "CDATA", dateTime);
        this.contentHandler.startElement(PROFILER_NS, PROFILERINFO_ELEMENT, "profiler:profilerinfo", atts);
        Collection resultsKeys = this.profiler.getResultKeys();
        Iterator i = resultsKeys.iterator();
        while (i.hasNext()) {
            Long key = (Long)i.next();
            if (this.key != null && !this.key.equals(key)) continue;
            this.generateResults(key, this.profiler.getResult(key));
        }
        this.contentHandler.endElement(PROFILER_NS, PROFILERINFO_ELEMENT, "profiler:profilerinfo");
    }

    private void generateResults(Long key, ProfilerResult result) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        int count = result.getCount();
        String[] roles = result.getRoles();
        String[] sources = result.getSources();
        EnvironmentInfo[] environmentInfos = result.getLatestEnvironmentInfos();
        long[] totalTime = result.getTotalTime();
        long[][] setupTimes = result.getSetupTimes();
        long[][] processingTimes = result.getProcessingTimes();
        Object[][] fragments = result.getSAXFragments();
        long totalTimeSum = 0L;
        for (int i = 0; i < count; ++i) {
            totalTimeSum += totalTime[i];
        }
        atts.addAttribute("", "uri", "uri", "CDATA", result.getURI());
        atts.addAttribute("", "count", "count", "CDATA", Integer.toString(result.getCount()));
        atts.addAttribute("", "processingTime", "processingTime", "CDATA", Long.toString(totalTimeSum));
        atts.addAttribute("", "key", "key", "CDATA", key.toString());
        this.contentHandler.startElement(PROFILER_NS, RESULTS_ELEMENT, "profiler:pipeline", atts);
        atts.clear();
        if (count > 0 && this.resultIndex == -1) {
            int i;
            atts.addAttribute("", "time", "time", "CDATA", Long.toString(totalTimeSum / (long)count));
            this.contentHandler.startElement(PROFILER_NS, AVERAGERESULT_ELEMENT, "profiler:average", atts);
            atts.clear();
            long[] totalTimeOfComponents = new long[roles.length];
            for (i = 0; i < roles.length; ++i) {
                totalTimeOfComponents[i] = 0L;
                for (int j = 0; j < count; ++j) {
                    int n = i;
                    totalTimeOfComponents[n] = totalTimeOfComponents[n] + (setupTimes[j][i] + processingTimes[j][i]);
                }
            }
            for (i = 0; i < roles.length; ++i) {
                atts.addAttribute("", "offset", "offset", "CDATA", String.valueOf(i));
                if (roles[i] != null) {
                    atts.addAttribute("", "role", "role", "CDATA", roles[i]);
                }
                if (sources[i] != null) {
                    atts.addAttribute("", "source", "source", "CDATA", sources[i]);
                }
                atts.addAttribute("", "time", "time", "CDATA", Long.toString(totalTimeOfComponents[i] / (long)count));
                this.contentHandler.startElement(PROFILER_NS, COMPONENT_ELEMENT, "profiler:component", atts);
                atts.clear();
                this.contentHandler.endElement(PROFILER_NS, COMPONENT_ELEMENT, "profiler:component");
            }
            this.contentHandler.endElement(PROFILER_NS, AVERAGERESULT_ELEMENT, "profiler:average");
        }
        for (int j = 0; j < count; ++j) {
            if (this.resultIndex != -1 && this.resultIndex != j) continue;
            this.generateResult(j, roles, sources, environmentInfos[j], totalTime[j], setupTimes[j], processingTimes[j], fragments[j]);
        }
        this.contentHandler.endElement(PROFILER_NS, RESULTS_ELEMENT, "profiler:pipeline");
    }

    private void generateResult(int resultIndex, String[] roles, String[] sources, EnvironmentInfo environmentInfo, long totalTime, long[] setupTimes, long[] processingTimes, Object[] fragments) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "time", "time", "CDATA", Long.toString(totalTime));
        atts.addAttribute("", "index", "index", "CDATA", String.valueOf(resultIndex));
        this.contentHandler.startElement(PROFILER_NS, RESULT_ELEMENT, "profiler:result", atts);
        atts.clear();
        if (this.resultIndex != -1) {
            this.generateEnvironmentInfo(environmentInfo);
        }
        for (int i = 0; i < roles.length; ++i) {
            this.generateComponent(i, roles[i], sources[i], setupTimes[i], processingTimes[i], fragments[i]);
        }
        this.contentHandler.endElement(PROFILER_NS, RESULT_ELEMENT, "profiler:result");
    }

    private void generateComponent(int componentIndex, String role, String source, long setupTime, long processingTime, Object fragment) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "index", "index", "CDATA", String.valueOf(componentIndex));
        if (role != null) {
            atts.addAttribute("", "role", "role", "CDATA", role);
        }
        if (source != null) {
            atts.addAttribute("", "source", "source", "CDATA", source);
        }
        atts.addAttribute("", "setup", "setup", "CDATA", Long.toString(setupTime));
        atts.addAttribute("", "processing", "processing", "CDATA", Long.toString(processingTime));
        atts.addAttribute("", "time", "time", "CDATA", Long.toString(setupTime + processingTime));
        this.contentHandler.startElement(PROFILER_NS, COMPONENT_ELEMENT, "profiler:component", atts);
        atts.clear();
        if (this.componentIndex == componentIndex) {
            this.contentHandler.startElement(PROFILER_NS, FRAGMENT_ELEMENT, "profiler:fragment", new AttributesImpl());
            this.generateSAXFragment(fragment, true);
            this.contentHandler.endElement(PROFILER_NS, FRAGMENT_ELEMENT, "profiler:fragment");
        }
        this.contentHandler.endElement(PROFILER_NS, COMPONENT_ELEMENT, "profiler:component");
    }

    private void generateEnvironmentInfo(EnvironmentInfo environmentInfo) throws SAXException {
        this.contentHandler.startElement(PROFILER_NS, ENVIROMENTINFO_ELEMENT, "profiler:environmentinfo", new AttributesImpl());
        if (environmentInfo != null) {
            this.contentHandler.startElement(PROFILER_NS, REQUESTPARAMETERS_ELEMENT, "profiler:request-parameters", new AttributesImpl());
            Map requestParameters = environmentInfo.getRequestParameters();
            Set requestParamEntries = requestParameters.entrySet();
            Iterator requestParamEntriesIt = requestParamEntries.iterator();
            while (requestParamEntriesIt.hasNext()) {
                AttributesImpl atts = new AttributesImpl();
                Map.Entry entry = requestParamEntriesIt.next();
                atts.addAttribute("", "name", "name", "CDATA", (String)entry.getKey());
                atts.addAttribute("", "value", "value", "CDATA", (String)entry.getValue());
                this.contentHandler.startElement(PROFILER_NS, REQUESTPARAMETER_ELEMENT, "profiler:parameter", atts);
                this.contentHandler.endElement(PROFILER_NS, REQUESTPARAMETER_ELEMENT, "profiler:parameter");
            }
            this.contentHandler.endElement(PROFILER_NS, REQUESTPARAMETERS_ELEMENT, "profiler:request-parameters");
            this.contentHandler.startElement(PROFILER_NS, SESSIONATTRIBUTES_ELEMENT, "profiler:session-attributes", new AttributesImpl());
            Map sessionAttributes = environmentInfo.getSessionAttributes();
            Set sessionAttrEntries = sessionAttributes.entrySet();
            Iterator sessionAttrEntriesIt = sessionAttrEntries.iterator();
            while (sessionAttrEntriesIt.hasNext()) {
                AttributesImpl atts = new AttributesImpl();
                Map.Entry entry = sessionAttrEntriesIt.next();
                atts.addAttribute("", "name", "name", "CDATA", (String)entry.getKey());
                atts.addAttribute("", "value", "value", "CDATA", (String)entry.getValue());
                this.contentHandler.startElement(PROFILER_NS, SESSIONATTRIBUTE_ELEMENT, "profiler:attribute", atts);
                this.contentHandler.endElement(PROFILER_NS, SESSIONATTRIBUTE_ELEMENT, "profiler:attribute");
            }
            this.contentHandler.endElement(PROFILER_NS, SESSIONATTRIBUTES_ELEMENT, "profiler:session-attributes");
            this.contentHandler.startElement(PROFILER_NS, "uri", "profiler:uri", new AttributesImpl());
            this.contentHandler.characters(environmentInfo.getURI().toCharArray(), 0, environmentInfo.getURI().length());
            this.contentHandler.endElement(PROFILER_NS, "uri", "profiler:uri");
        }
        this.contentHandler.endElement(PROFILER_NS, ENVIROMENTINFO_ELEMENT, "profiler:environmentinfo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateSAXFragment(Object fragment, boolean embed) throws SAXException {
        if (fragment == null) return;
        XMLDeserializer deserializer = null;
        try {
            try {
                deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                if (embed) {
                    deserializer.setConsumer((XMLConsumer)new IncludeXMLConsumer(this.xmlConsumer));
                } else {
                    deserializer.setConsumer(this.xmlConsumer);
                }
                deserializer.deserialize(fragment);
            }
            catch (ServiceException ce) {
                this.getLogger().debug("Could not retrieve XMLDeserializer component", (Throwable)ce);
                throw new SAXException("Could not retrieve XMLDeserializer component", (Exception)((Object)ce));
            }
            catch (Exception e) {
                this.getLogger().debug("Could not serialize SAX fragment", (Throwable)e);
                throw new SAXException("Could not serialize SAX fragment", e);
            }
            Object var6_4 = null;
            if (deserializer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (deserializer == null) throw throwable;
            this.manager.release((Object)deserializer);
            throw throwable;
        }
        this.manager.release((Object)deserializer);
    }
}

