/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.url;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.util.AbstractParsedURLProtocolHandler;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.components.url.StreamJDKRegistryEntry;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SourceProtocolHandler
extends AbstractParsedURLProtocolHandler {
    protected static InheritableThreadLocal localResolver = new InheritableThreadLocal();
    protected static ParsedURLProtocolHandler defaultHandler = ParsedURL.getHandler(null);

    public static void setup(SourceResolver resolver) {
        localResolver.set(resolver);
    }

    public static SourceResolver getSourceResolver() {
        SourceResolver resolver = (SourceResolver)localResolver.get();
        return resolver;
    }

    public SourceProtocolHandler(String protocol) {
        super(protocol);
    }

    public ParsedURLData parseURL(ParsedURL baseURL, String urlStr) {
        SourceResolver resolver = (SourceResolver)localResolver.get();
        if (resolver == null) {
            return defaultHandler == null ? null : defaultHandler.parseURL(baseURL, urlStr);
        }
        return new SourceParsedURLData(urlStr, resolver);
    }

    public ParsedURLData parseURL(String urlStr) {
        SourceResolver resolver = (SourceResolver)localResolver.get();
        if (resolver == null) {
            return defaultHandler == null ? null : defaultHandler.parseURL(urlStr);
        }
        return new SourceParsedURLData(urlStr, resolver);
    }

    static {
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new SourceProtocolHandler(null));
        ImageTagRegistry.getRegistry().register((RegistryEntry)new StreamJDKRegistryEntry());
    }

    static class SourceParsedURLData
    extends ParsedURLData {
        public String url;
        private Source source;
        private SourceResolver resolver;

        public SourceParsedURLData(String urlStr, SourceResolver resolver) {
            this.url = urlStr;
            this.resolver = resolver;
            int pidx = 0;
            int idx = urlStr.indexOf(58);
            if (idx != -1) {
                this.protocol = urlStr.substring(pidx, idx);
                if (this.protocol.indexOf(47) == -1) {
                    pidx = idx + 1;
                } else {
                    this.protocol = null;
                    pidx = 0;
                }
            }
            if ((idx = urlStr.indexOf(44, pidx)) != -1) {
                this.host = urlStr.substring(pidx, idx);
                pidx = idx + 1;
            }
            if (pidx != urlStr.length()) {
                this.path = urlStr.substring(pidx);
            }
            try {
                this.source = resolver.resolveURI(this.url);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Cannot resolve " + this.url, (Throwable)e);
            }
            this.contentType = this.source.getMimeType();
            if (this.contentType == null) {
                if (this.url.endsWith(".gif")) {
                    this.contentType = "image/gif";
                } else if (this.url.endsWith(".jpeg") || this.url.endsWith(".jpg")) {
                    this.contentType = "image/jpeg";
                } else if (this.url.endsWith(".png")) {
                    this.contentType = "image/png";
                }
            }
        }

        public boolean complete() {
            return this.url != null;
        }

        public String getPortStr() {
            String portStr = this.protocol + ":";
            if (this.host != null) {
                portStr = portStr + this.host;
            }
            portStr = portStr + ",";
            return portStr;
        }

        public String toString() {
            return this.url;
        }

        protected InputStream openStreamInternal(String userAgent, Iterator mimeTypes, Iterator encodingTypes) throws IOException {
            try {
                InputStream inputStream = this.source.getInputStream();
                return inputStream;
            }
            catch (Exception e) {
                throw new CascadingIOException("Cannot open URL " + this.url, (Throwable)e);
            }
            finally {
                this.resolver.release(this.source);
            }
        }
    }
}

