/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.InputStreamSink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CommandRunner {
    private static final int BUFFER_SIZE = 1024;
    private static final long ONE_MINUTE = 60000L;
    private long _maxExecutionTime = 180000L;
    private String _output;
    private String _error;
    private int _runningSinks;
    private byte[] _lock = new byte[0];

    public String getOutput() {
        return this._output;
    }

    public String getError() {
        return this._error;
    }

    public synchronized void runCommand(String workingCopy, String[] command) throws CommandException {
        Runtime rt = Runtime.getRuntime();
        try {
            File dir;
            if (workingCopy != null) {
                dir = new File(workingCopy);
                if (!dir.exists()) {
                    dir = new File(System.getProperty("user.home"));
                }
            } else {
                dir = new File(System.getProperty("user.home"));
            }
            Process proc = rt.exec(command, null, dir);
            InputStream stdout = proc.getInputStream();
            InputStream stderr = proc.getErrorStream();
            StringBuffer output = new StringBuffer(1024);
            StringBuffer error = new StringBuffer(1024);
            this._runningSinks = 2;
            Thread stdOutSink = new Thread(new InputStreamSink(stdout, output, this));
            Thread stdErrSink = new Thread(new InputStreamSink(stderr, error, this));
            stdOutSink.start();
            stdErrSink.start();
            while (true) {
                try {
                    byte[] byArray = this._lock;
                    synchronized (byArray) {
                        if (this._runningSinks == 0) {
                            break;
                        }
                        this._lock.wait(this._maxExecutionTime);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            this._output = output.toString();
            this._error = error.toString();
            proc.destroy();
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage());
        }
    }

    public void finished() {
        byte[] byArray = this._lock;
        synchronized (byArray) {
            --this._runningSinks;
            this._lock.notify();
        }
    }
}

