/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class Copy
extends Command
implements WorkingCopyModifiable {
    public static final String SOURCE = "SOURCE";
    public static final String DESTINATION = "DESTINATION";
    public static final String REVISION = "REVISION";
    public static final String COPY_MESSAGE = "COPY_MESSAGE";

    public void init(Map args) throws CommandException {
        String copyMessage;
        super.init(args);
        String source = (String)args.get(SOURCE);
        if (source == null || "".equals(source.trim())) {
            throw new CommandException("Missing source");
        }
        String destination = (String)args.get(DESTINATION);
        if (destination == null || "".equals(destination.trim())) {
            throw new CommandException("Missing destination");
        }
        this.addCommand("svn");
        this.addCommand("copy");
        String revision = (String)args.get(REVISION);
        if (revision != null && !"".equals(revision.trim())) {
            this.addCommand("-r");
            this.addCommand(revision);
        }
        if ((copyMessage = (String)args.get(COPY_MESSAGE)) == null) {
            copyMessage = "*** Empty message ***";
        }
        try {
            File tempFile = File.createTempFile("jsvn", ".tmp", null);
            tempFile.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
            out.write(copyMessage);
            out.close();
            this.addCommand("--file");
            this.addCommand(tempFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new CommandException("Error while building copy command.  Original exception: " + e.getMessage());
        }
        this.addCommand(source);
        this.addCommand(destination);
        this.addCommand("--non-interactive");
    }
}

