/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.configuration;

import com.alternatecomputing.jsvn.configuration.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigurationManager {
    private static final String CONFIG_LOCATION = ".jsvn" + File.separator + "config";
    private static final String JSVN_WORKING_COPY = "jsvn.working_copy";
    private static ConfigurationManager _instance;
    private Configuration _config;
    private Properties _props = new Properties();
    private String _userHome = System.getProperty("user.home");
    private File _configFile = new File(this._userHome + File.separator + CONFIG_LOCATION);
    static /* synthetic */ Class class$com$alternatecomputing$jsvn$configuration$ConfigurationManager;

    public static ConfigurationManager getInstance() {
        if (_instance == null) {
            Class clazz = class$com$alternatecomputing$jsvn$configuration$ConfigurationManager == null ? (class$com$alternatecomputing$jsvn$configuration$ConfigurationManager = ConfigurationManager.class$("com.alternatecomputing.jsvn.configuration.ConfigurationManager")) : class$com$alternatecomputing$jsvn$configuration$ConfigurationManager;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new ConfigurationManager();
                    ConfigurationManager._instance._config = new Configuration();
                    _instance.loadConfig();
                }
            }
        }
        return _instance;
    }

    private boolean createConfigDir() {
        boolean status = true;
        File configDir = new File(this._userHome + File.separator + ".jsvn");
        if (!configDir.exists()) {
            status = configDir.mkdir();
        }
        return status;
    }

    public void loadConfig() {
        try {
            if (this._configFile.exists()) {
                this._props.load(new FileInputStream(this._configFile));
                this._config = new Configuration();
                this._config.setWorkingCopy(this._props.getProperty(JSVN_WORKING_COPY));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            this._props.setProperty(JSVN_WORKING_COPY, this._config.getWorkingCopy());
            if (!this.createConfigDir()) {
                throw new IOException("Could not save configuration");
            }
            this._props.store(new FileOutputStream(this._configFile), "JSVN Config");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setConfig(Configuration config) {
        this._config = config;
    }

    public String getWorkingCopy() {
        return this._config.getWorkingCopy();
    }

    public String getWorkingDirectory() {
        return this._config.getWorkingDirectory();
    }

    public Configuration getConfig() {
        return (Configuration)this._config.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

