/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.CommandRunner;
import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.gui.Frame;
import com.alternatecomputing.jsvn.gui.SplashScreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Application {
    private static Frame _applicationFrame = null;
    private static final String ERR_NO_SVN = "Could not locate \"svn\" in your PATH, please correct this and try again";
    private static final String ERR_MISSING_PROGRAM = "Missing Program";
    public static String SVN_CMD_VERSION;

    public Application() {
        ConfigurationManager.getInstance().loadConfig();
        try {
            CommandRunner runner = new CommandRunner();
            runner.runCommand(ConfigurationManager.getInstance().getWorkingCopy(), new String[]{"svn", "--version"});
            SVN_CMD_VERSION = runner.getOutput();
        }
        catch (CommandException ex) {
            JOptionPane.showMessageDialog(new JFrame(), ERR_NO_SVN, ERR_MISSING_PROGRAM, 0);
            System.exit(1);
        }
        _applicationFrame = new Frame();
        SplashScreen splashScreen = new SplashScreen("/com/alternatecomputing/jsvn/gui/resources/jsvn_logo.png", _applicationFrame, 5000);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = _applicationFrame.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        ((Component)_applicationFrame).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        _applicationFrame.setVisible(true);
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Application();
    }

    public static Frame getApplicationFrame() {
        return _applicationFrame;
    }

    public static void setApplicationFrame(Frame frame) {
        _applicationFrame = frame;
    }
}

