/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DirectoryBrowserTableModel
extends AbstractTableModel {
    private File[] files = new File[0];
    private SVNTreeNodeData _node;
    private List _contents;

    public int getRowCount() {
        return this._contents == null ? 0 : this._contents.size();
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Filename";
            }
            case 1: {
                return "Status";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Size";
            }
            case 4: {
                return "Date Modified";
            }
            case 5: {
                return "Revision";
            }
            case 6: {
                return "Last Revision";
            }
            case 7: {
                return "Last Author";
            }
        }
        return super.getColumnName(column);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SVNTreeNodeData nodeData = (SVNTreeNodeData)this._contents.get(rowIndex);
        File file = new File(ConfigurationManager.getInstance().getWorkingDirectory() + "/" + nodeData.getPath());
        switch (columnIndex) {
            case 0: {
                return this.formatFilesAndDirectories(nodeData, nodeData.getName());
            }
            case 1: {
                return this.formatFilesAndDirectories(nodeData, nodeData.getStatusText());
            }
            case 2: {
                return this.formatFilesAndDirectories(nodeData, nodeData.getNodeKind() == 0 ? "File" : "Directory");
            }
            case 3: {
                if (file.isDirectory()) {
                    return "";
                }
                return this.formatFilesAndDirectories(nodeData, Long.toString(file.length()));
            }
            case 4: {
                return this.formatFilesAndDirectories(nodeData, new Date(file.lastModified()).toString());
            }
            case 5: {
                return this.formatFilesAndDirectories(nodeData, Integer.toString(nodeData.getRevision()));
            }
            case 6: {
                return this.formatFilesAndDirectories(nodeData, Integer.toString(nodeData.getLastChangedRevision()));
            }
            case 7: {
                return this.formatFilesAndDirectories(nodeData, nodeData.getLastChangedAuthor());
            }
        }
        return null;
    }

    private String formatFilesAndDirectories(SVNTreeNodeData data, String s) {
        if (s == null) {
            return "";
        }
        if (data.getNodeKind() == 1) {
            return "<html><i>" + s + "</i></html>";
        }
        return s;
    }

    private SVNTreeNodeData findNamedChildNode(String name) {
        Iterator iterator = this._node.getChildren().iterator();
        while (iterator.hasNext()) {
            SVNTreeNodeData nodeData = (SVNTreeNodeData)iterator.next();
            if (!name.equals(nodeData.getName())) continue;
            return nodeData;
        }
        return null;
    }

    public void setPathToBrowse(SVNTreeNodeData node, File pathToBrowse) {
        this._contents = node.getChildren();
        this._node = node;
        this.fireTableDataChanged();
    }

    public void clearPathToBrowse() {
        this.files = new File[0];
        this.fireTableDataChanged();
    }

    public SVNTreeNodeData getNodeForRow(int rowIndex) {
        return (SVNTreeNodeData)this._contents.get(rowIndex);
    }
}

