/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.Commandable;
import com.alternatecomputing.jsvn.gui.JSVNCommandEvent;
import com.alternatecomputing.jsvn.gui.JSVNEventListener;
import com.alternatecomputing.jsvn.gui.JSVNStatusEvent;
import com.alternatecomputing.jsvn.gui.JSVNUIEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;

public class JSVNCommandExecutor
implements Runnable {
    private Commandable _command;
    private Map _args;
    private Collection _jsvnEventListeners;

    public JSVNCommandExecutor(Commandable command, Map args) {
        this._command = command;
        this._args = args;
        this._jsvnEventListeners = new HashSet();
    }

    public void addJSVNEventListener(JSVNEventListener listener) {
        this._jsvnEventListeners.add(listener);
    }

    private void notifyListerers(final JSVNUIEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Iterator iterator = JSVNCommandExecutor.this._jsvnEventListeners.iterator();
                while (iterator.hasNext()) {
                    JSVNEventListener jsvnEventListener = (JSVNEventListener)iterator.next();
                    if (jsvnEventListener == null) continue;
                    jsvnEventListener.processJSVNEvent(event);
                }
            }
        });
    }

    public void run() {
        try {
            try {
                this.notifyListerers(new JSVNStatusEvent(1));
                this._command.init(this._args);
                this._command.execute();
                String result = this._command.getResult();
                JSVNCommandEvent commandEvent = new JSVNCommandEvent();
                commandEvent.setCommand(this._command);
                commandEvent.setResult(result);
                this.notifyListerers(commandEvent);
            }
            catch (CommandException e) {
                JSVNCommandEvent commandEvent = new JSVNCommandEvent();
                commandEvent.setError(e.getMessage());
                this.notifyListerers(commandEvent);
                Object var4_6 = null;
                this.notifyListerers(new JSVNStatusEvent(0));
            }
            Object var4_5 = null;
            this.notifyListerers(new JSVNStatusEvent(0));
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.notifyListerers(new JSVNStatusEvent(0));
            throw throwable;
        }
    }
}

