/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.gui.GenericCellRendererHelper;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class JSVNTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SVNTreeNodeData data = (SVNTreeNodeData)((DefaultMutableTreeNode)value).getUserObject();
        if (data == null) {
            return this;
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (data.getNodeKind() == 1) {
            if (expanded) {
                this.setIcon((Icon)UIManager.get("Tree.openIcon"));
            } else {
                this.setIcon((Icon)UIManager.get("Tree.closedIcon"));
            }
        }
        this.setForeground(GenericCellRendererHelper.getStatusColor(data));
        StringBuffer tipText = new StringBuffer("<html>Path: ").append(data.getPath()).append("<br>Name: ").append(data.getName());
        if (data.getRevision() != -1 && data.getRevision() != -2) {
            tipText.append("<br>Revision: ").append(data.getRevision());
        }
        tipText.append("<br>Node kind: ").append(data.getNodeKind() == 1 ? "directory" : "file");
        if (data.getNodeKind() == 0) {
            File f = new File(ConfigurationManager.getInstance().getWorkingDirectory() + data.getPath());
            tipText.append("<br>Size: ").append(f.length()).append(" bytes");
        }
        if (data.getLastChangedAuthor() != null) {
            tipText.append("<br>Last Changed Author: ").append(data.getLastChangedAuthor());
        }
        if (data.getLastChangedRevision() != -1 && data.getLastChangedRevision() != -2) {
            tipText.append("<br>Last Changed Rev: ").append(data.getLastChangedRevision()).append("</html>");
        }
        this.setToolTipText(tipText.toString());
        return this;
    }
}

