/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Modifiable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.RequestListener;
import org.apache.cocoon.components.container.CocoonServiceManager;
import org.apache.cocoon.components.container.ComponentContext;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.core.container.ConfigurationBuilder;
import org.apache.cocoon.core.container.RoleManager;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.impl.URLSource;
import org.xml.sax.InputSource;

public class Cocoon
extends AbstractLogEnabled
implements ThreadSafe,
Initializable,
Disposable,
Modifiable,
Processor,
Contextualizable,
Serviceable {
    static Cocoon instance;
    private org.apache.avalon.framework.context.Context context;
    private Source configurationFile;
    private LoggerManager loggerManager;
    private String classpath;
    private File workDir;
    private ServiceManager parentServiceManager;
    private boolean disposed = false;
    private volatile int activeRequestCount = 0;
    private Processor threadSafeProcessor;
    protected org.apache.excalibur.source.SourceResolver sourceResolver;
    protected EnvironmentHelper environmentHelper;
    protected CocoonServiceManager serviceManager;
    protected RequestListener requestListener;

    public Cocoon() throws ConfigurationException {
        this.setSystemProperties();
        instance = this;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.parentServiceManager = manager;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.context == null) {
            this.context = new ComponentContext(context);
            ((DefaultContext)this.context).makeReadOnly();
            this.classpath = (String)context.get((Object)"classpath");
            this.workDir = (File)context.get((Object)"work-directory");
            try {
                URLSource urlSource = new URLSource();
                urlSource.init((URL)context.get((Object)"config-url"), null);
                this.configurationFile = new DelayedRefreshSourceWrapper((Source)urlSource, 1000L);
            }
            catch (IOException ioe) {
                throw new ContextException("Could not open configuration file.", (Throwable)ioe);
            }
            catch (Exception e) {
                throw new ContextException("contextualize(..) Exception", (Throwable)e);
            }
        }
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    public void initialize() throws Exception {
        this.serviceManager = new CocoonServiceManager(this.parentServiceManager);
        ContainerUtil.enableLogging((Object)((Object)this.serviceManager), (Logger)this.getLogger().getChildLogger("manager"));
        ContainerUtil.contextualize((Object)((Object)this.serviceManager), (org.apache.avalon.framework.context.Context)this.context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New Cocoon object.");
        }
        this.dumpSystemProperties();
        this.configure();
        ContainerUtil.initialize((Object)((Object)this.serviceManager));
        Processor processor = (Processor)this.serviceManager.lookup(Processor.ROLE);
        if (processor instanceof ThreadSafe) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is ThreadSafe");
            }
            this.threadSafeProcessor = processor;
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processor of class " + processor.getClass().getName() + " is NOT ThreadSafe -- will be looked up at each request");
            }
            this.serviceManager.release(processor);
        }
        this.environmentHelper = new EnvironmentHelper((String)this.context.get((Object)"root-url"));
        ContainerUtil.enableLogging((Object)this.environmentHelper, (Logger)this.getLogger());
        ContainerUtil.service((Object)this.environmentHelper, (ServiceManager)this.serviceManager);
        this.sourceResolver = (org.apache.excalibur.source.SourceResolver)this.serviceManager.lookup(org.apache.excalibur.source.SourceResolver.ROLE);
        if (this.serviceManager.hasService(RequestListener.ROLE)) {
            this.requestListener = (RequestListener)this.serviceManager.lookup(RequestListener.ROLE);
        }
    }

    private void dumpSystemProperties() {
        if (this.getLogger().isDebugEnabled()) {
            try {
                Enumeration<?> e = System.getProperties().propertyNames();
                this.getLogger().debug("===== System Properties Start =====");
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.getLogger().debug(key + "=" + System.getProperty(key));
                }
                this.getLogger().debug("===== System Properties End =====");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private void configure() throws Exception {
        InputSource is = SourceUtil.getInputSource(this.configurationFile);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Configuration conf = builder.build(is);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Root configuration: " + conf.getName());
        }
        if (!"cocoon".equals(conf.getName())) {
            throw new ConfigurationException("Invalid configuration file\n" + conf.toString());
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuration version: " + conf.getAttribute("version"));
        }
        if (!"2.2".equals(conf.getAttribute("version"))) {
            throw new ConfigurationException("Invalid configuration schema version. Must be '2.2'.");
        }
        RoleManager drm = null;
        String userRoles = conf.getAttribute("user-roles", "");
        if (!"".equals(userRoles)) {
            Configuration roleConfig;
            try {
                Context context = (Context)this.context.get((Object)"environment-context");
                URL url = context.getResource(userRoles);
                if (url == null) {
                    throw new ConfigurationException("User-roles configuration '" + userRoles + "' cannot be found.");
                }
                is = new InputSource(new BufferedInputStream(url.openStream()));
                is.setSystemId(this.configurationFile.getURI());
                roleConfig = builder.build(is);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error trying to load user-roles configuration", (Throwable)e);
            }
            RoleManager urm = new RoleManager(drm);
            ContainerUtil.enableLogging((Object)((Object)urm), (Logger)this.getLogger().getChildLogger("roles").getChildLogger("user"));
            ContainerUtil.configure((Object)((Object)urm), (Configuration)roleConfig);
            roleConfig = null;
            drm = urm;
        }
        this.serviceManager.setRoleManager(drm);
        this.serviceManager.setLoggerManager(this.loggerManager);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting up components...");
        }
        ContainerUtil.configure((Object)((Object)this.serviceManager), (Configuration)conf);
    }

    public boolean modifiedSince(long date) {
        return date < this.configurationFile.getLastModified();
    }

    protected void setSystemProperties() {
        Properties props = new Properties();
        props.put("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        Properties systemProps = System.getProperties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String prop = (String)propEnum.nextElement();
            if (systemProps.containsKey(prop)) continue;
            systemProps.put(prop, props.getProperty(prop));
        }
        if (systemProps.containsKey("javax.xml.parsers.DocumentBuilderFactory") && systemProps.getProperty("javax.xml.parsers.DocumentBuilderFactory").startsWith("weblogic")) {
            systemProps.put("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            systemProps.put("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        System.setProperties(systemProps);
    }

    public void dispose() {
        if (this.serviceManager != null) {
            if (this.requestListener != null) {
                this.serviceManager.release(this.requestListener);
            }
            this.serviceManager.release(this.threadSafeProcessor);
            this.threadSafeProcessor = null;
            this.serviceManager.release(this.sourceResolver);
            this.sourceResolver = null;
            ContainerUtil.dispose((Object)((Object)this.serviceManager));
            this.serviceManager = null;
        }
        this.context = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debug(Environment environment, boolean internal) {
        String lineSeparator = SystemUtils.LINE_SEPARATOR;
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        StringBuffer msg = new StringBuffer();
        msg.append("DEBUGGING INFORMATION:").append(lineSeparator);
        if (internal) {
            msg.append("INTERNAL ");
        }
        msg.append("REQUEST: ").append(request.getRequestURI()).append(lineSeparator).append(lineSeparator);
        msg.append("CONTEXT PATH: ").append(request.getContextPath()).append(lineSeparator);
        msg.append("SERVLET PATH: ").append(request.getServletPath()).append(lineSeparator);
        msg.append("PATH INFO: ").append(request.getPathInfo()).append(lineSeparator).append(lineSeparator);
        msg.append("REMOTE HOST: ").append(request.getRemoteHost()).append(lineSeparator);
        msg.append("REMOTE ADDRESS: ").append(request.getRemoteAddr()).append(lineSeparator);
        msg.append("REMOTE USER: ").append(request.getRemoteUser()).append(lineSeparator);
        msg.append("REQUEST SESSION ID: ").append(request.getRequestedSessionId()).append(lineSeparator);
        msg.append("REQUEST PREFERRED LOCALE: ").append(request.getLocale().toString()).append(lineSeparator);
        msg.append("SERVER HOST: ").append(request.getServerName()).append(lineSeparator);
        msg.append("SERVER PORT: ").append(request.getServerPort()).append(lineSeparator).append(lineSeparator);
        msg.append("METHOD: ").append(request.getMethod()).append(lineSeparator);
        msg.append("CONTENT LENGTH: ").append(request.getContentLength()).append(lineSeparator);
        msg.append("PROTOCOL: ").append(request.getProtocol()).append(lineSeparator);
        msg.append("SCHEME: ").append(request.getScheme()).append(lineSeparator);
        msg.append("AUTH TYPE: ").append(request.getAuthType()).append(lineSeparator).append(lineSeparator);
        msg.append("CURRENT ACTIVE REQUESTS: ").append(this.activeRequestCount).append(lineSeparator);
        Enumeration e = request.getParameterNames();
        msg.append("REQUEST PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            String[] params = request.getParameterValues(p);
            for (int i = 0; i < params.length; ++i) {
                msg.append("[" + params[i] + "]");
                if (i == params.length - 1) continue;
                msg.append(", ");
            }
            msg.append("'").append(lineSeparator);
        }
        Enumeration e2 = request.getHeaderNames();
        msg.append("HEADER PARAMETERS:").append(lineSeparator).append(lineSeparator);
        while (e2.hasMoreElements()) {
            String p = (String)e2.nextElement();
            msg.append("PARAM: '").append(p).append("' ").append("VALUES: '");
            Enumeration e3 = request.getHeaders(p);
            while (e3.hasMoreElements()) {
                msg.append("[" + e3.nextElement() + "]");
                if (!e3.hasMoreElements()) continue;
                msg.append(", ");
            }
            msg.append("'").append(lineSeparator);
        }
        msg.append(lineSeparator).append("SESSION ATTRIBUTES:").append(lineSeparator).append(lineSeparator);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                e = session.getAttributeNames();
                while (e.hasMoreElements()) {
                    String p = (String)e.nextElement();
                    msg.append("PARAM: '").append(p).append("' ").append("VALUE: '").append(session.getAttribute(p)).append("'").append(lineSeparator);
                }
            }
        }
        this.getLogger().debug(msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Environment environment) throws Exception {
        boolean processor2;
        if (this.disposed) {
            throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
        }
        environment.startingProcessing();
        int environmentDepth = EnvironmentHelper.markEnvironment();
        EnvironmentHelper.enterProcessor(this, this.serviceManager, environment);
        try {
            boolean result;
            if (this.getLogger().isDebugEnabled()) {
                ++this.activeRequestCount;
                this.debug(environment, false);
            }
            if (this.requestListener != null) {
                try {
                    this.requestListener.onRequestStart(environment);
                }
                catch (Exception e) {
                    this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                }
            }
            if (this.threadSafeProcessor != null) {
                result = this.threadSafeProcessor.process(environment);
                if (this.requestListener != null) {
                    try {
                        this.requestListener.onRequestEnd(environment);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                    }
                }
            } else {
                Processor processor2 = (Processor)this.serviceManager.lookup(Processor.ROLE);
                try {
                    result = processor2.process(environment);
                    if (this.requestListener != null) {
                        try {
                            this.requestListener.onRequestEnd(environment);
                        }
                        catch (Exception e) {
                            this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                        }
                    }
                }
                finally {
                    this.serviceManager.release(processor2);
                }
            }
            environment.commitResponse();
            processor2 = result;
            Object var8_12 = null;
        }
        catch (Exception any) {
            try {
                if (this.requestListener != null) {
                    try {
                        this.requestListener.onRequestException(environment, any);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error encountered monitoring request start: " + e.getMessage());
                    }
                }
                environment.tryResetResponse();
                throw any;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                EnvironmentHelper.leaveProcessor();
                environment.finishingProcessing();
                if (this.getLogger().isDebugEnabled()) {
                    --this.activeRequestCount;
                }
                EnvironmentHelper.checkEnvironment(environmentDepth, this.getLogger());
                throw throwable;
            }
        }
        EnvironmentHelper.leaveProcessor();
        environment.finishingProcessing();
        if (this.getLogger().isDebugEnabled()) {
            --this.activeRequestCount;
        }
        EnvironmentHelper.checkEnvironment(environmentDepth, this.getLogger());
        return processor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Processor.InternalPipelineDescription buildPipeline(Environment environment) throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("You cannot process a Disposed Cocoon engine.");
        }
        try {
            Processor.InternalPipelineDescription internalPipelineDescription;
            if (this.getLogger().isDebugEnabled()) {
                ++this.activeRequestCount;
                this.debug(environment, true);
            }
            if (this.threadSafeProcessor != null) {
                Processor.InternalPipelineDescription internalPipelineDescription2 = this.threadSafeProcessor.buildPipeline(environment);
                return internalPipelineDescription2;
            }
            Processor processor = (Processor)this.serviceManager.lookup(Processor.ROLE);
            try {
                internalPipelineDescription = processor.buildPipeline(environment);
            }
            catch (Throwable throwable) {
                this.serviceManager.release(processor);
                throw throwable;
            }
            this.serviceManager.release(processor);
            return internalPipelineDescription;
        }
        finally {
            if (this.getLogger().isDebugEnabled()) {
                --this.activeRequestCount;
            }
        }
    }

    public Configuration[] getComponentConfigurations() {
        return null;
    }

    public Processor getRootProcessor() {
        return this;
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    public SourceResolver getSourceResolver() {
        return this.environmentHelper;
    }

    public String getContext() {
        return this.environmentHelper.getContext();
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }
}

