/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean.helpers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.bean.BeanListener;
import org.apache.cocoon.bean.Target;

public class OutputStreamListener
implements BeanListener {
    private final PrintWriter writer;
    private final Map brokenLinks = new HashMap();
    private final long startTimeMillis;
    private String reportFile = null;
    private String reportType = "text";
    private long siteSize = 0L;
    private int sitePages = 0;
    private boolean isShowingReferrers = false;

    public OutputStreamListener(OutputStream os) {
        this.writer = new PrintWriter(os);
        this.startTimeMillis = System.currentTimeMillis();
    }

    public void setReportFile(String filename) {
        this.reportFile = filename;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public void setIsShowingReferrers(boolean isShowingReferrers) {
        this.isShowingReferrers = isShowingReferrers;
    }

    public void pageGenerated(String sourceURI, String destinationURI, int pageSize, int linksInPage, int newLinksInPage, int pagesRemaining, int pagesComplete, long timeTaken) {
        this.siteSize += (long)pageSize;
        ++this.sitePages;
        double time = (double)timeTaken / 1000.0;
        String size = pageSize < 1024 ? pageSize + "b" : (float)((int)((double)pageSize / 102.4)) / 10.0f + "Kb";
        if (linksInPage == -1) {
            this.print("* " + sourceURI);
        } else {
            this.print(this.pad(12, "* [" + pagesComplete + "/" + pagesRemaining + "] ") + this.pad(10, "[" + newLinksInPage + "/" + linksInPage + "] ") + this.pad(7, time + "s ") + this.pad(7, size) + " " + sourceURI);
        }
    }

    public void messageGenerated(String msg) {
        this.print(msg);
    }

    public void warningGenerated(String uri, String warning) {
        this.print("Warning: " + warning + " when generating " + uri);
    }

    public void brokenLinkFound(String uri, String parentURI, String message, Throwable t) {
        this.print(this.pad(42, "X [0] ") + uri + "\tBROKEN: " + message);
        this.brokenLinks.put(uri + "\t" + message, "");
    }

    public void brokenLinkFound(Target target, Throwable t) {
        this.print(this.pad(42, "X [0] ") + target.getSourceURI() + "\tBROKEN: " + t.getMessage());
        this.brokenLinks.put(target.getSourceURI() + "\t" + t.getMessage(), target);
    }

    public void pageSkipped(String uri, String message) {
        this.print(this.pad(37, "^ ") + uri);
    }

    public void complete() {
        this.outputBrokenLinks();
        long duration = System.currentTimeMillis() - this.startTimeMillis;
        DecimalFormat df = new DecimalFormat("###,###,##0");
        this.print("Total time: " + duration / 60000L + " minutes " + duration % 60000L / 1000L + " seconds, " + " Site size: " + df.format(this.siteSize) + " Site pages: " + this.sitePages);
        this.close();
    }

    public boolean isSuccessful() {
        return this.brokenLinks.size() == 0;
    }

    private void outputBrokenLinks() {
        if (this.reportFile == null) {
            return;
        }
        if ("text".equalsIgnoreCase(this.reportType)) {
            this.outputBrokenLinksAsText();
        } else if ("xml".equalsIgnoreCase(this.reportType)) {
            this.outputBrokenLinksAsXML();
        }
    }

    private void outputBrokenLinksAsText() {
        try {
            PrintWriter writer = new PrintWriter((Writer)new FileWriter(new File(this.reportFile)), true);
            Iterator i = this.brokenLinks.keySet().iterator();
            while (i.hasNext()) {
                writer.println((String)i.next());
            }
            writer.close();
        }
        catch (IOException ioe) {
            this.print("Broken link file does not exist: " + this.reportFile);
        }
    }

    private void outputBrokenLinksAsXML() {
        try {
            PrintWriter writer = new PrintWriter((Writer)new FileWriter(new File(this.reportFile)), true);
            writer.println("<broken-links>");
            Iterator i = this.brokenLinks.keySet().iterator();
            while (i.hasNext()) {
                String linkMsg = (String)i.next();
                String uri = linkMsg.substring(0, linkMsg.indexOf(9));
                String msg = linkMsg.substring(linkMsg.indexOf(9) + 1);
                if (!this.isShowingReferrers) {
                    writer.println("  <link message=\"" + msg + "\">" + uri + "</link>");
                    continue;
                }
                writer.println("  <link message=\"" + msg + "\" uri=\"" + uri + "\">");
                Object t = this.brokenLinks.get(linkMsg);
                if (t instanceof Target) {
                    Target target = (Target)t;
                    Iterator j = target.getReferringURIs().iterator();
                    while (j.hasNext()) {
                        String referrer = (String)j.next();
                        writer.println("    <referrer uri=\"" + referrer + "\"/>");
                    }
                }
                writer.println("  </link>");
            }
            writer.println("</broken-links>");
            writer.close();
        }
        catch (IOException ioe) {
            this.print("Could not create broken link file: " + this.reportFile);
        }
    }

    private String pad(int chars, String str) {
        int len = str.length();
        if (len < chars) {
            StringBuffer sb = new StringBuffer(chars > len ? chars + 1 : len + 1);
            sb.append(str);
            for (int i = len; i < chars; ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return str;
    }

    private void print(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    private void close() {
        this.writer.flush();
    }
}

