/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class LifecycleHelper {
    private final Logger logger;
    private final Context context;
    private final ServiceManager serviceManager;
    private final Configuration configuration;

    public LifecycleHelper(Logger logger, Context context, ServiceManager serviceManager, Configuration configuration) {
        this.logger = logger;
        this.context = context;
        this.serviceManager = serviceManager;
        this.configuration = configuration;
    }

    public Object setupComponent(Object component) throws Exception {
        return this.setupComponent(component, true);
    }

    public Object setupComponent(Object component, boolean initializeAndStart) throws Exception {
        return LifecycleHelper.setupComponent(component, this.logger, this.context, this.serviceManager, this.configuration, initializeAndStart);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ServiceManager serviceManager, Configuration configuration) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, serviceManager, configuration, true);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ServiceManager serviceManager, Configuration configuration, boolean initializeAndStart) throws Exception {
        if (component instanceof LogEnabled) {
            ((LogEnabled)component).enableLogging(logger);
        }
        if (null != context && component instanceof Contextualizable) {
            ((Contextualizable)component).contextualize(context);
        }
        if (null != serviceManager && component instanceof Serviceable) {
            ((Serviceable)component).service(serviceManager);
        }
        if (null != configuration && component instanceof Configurable) {
            ((Configurable)component).configure(configuration);
        }
        if (null != configuration && component instanceof Parameterizable) {
            ((Parameterizable)component).parameterize(Parameters.fromConfiguration((Configuration)configuration));
        }
        if (initializeAndStart && component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (initializeAndStart && component instanceof Startable) {
            ((Startable)component).start();
        }
        return component;
    }

    public static final void decommission(Object component) throws Exception {
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        LifecycleHelper.dispose(component);
    }

    public static final void dispose(Object component) {
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
    }
}

