/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.SitemapConfigurable;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.components.container.DefaultSitemapConfigurationHolder;
import org.apache.cocoon.components.treeprocessor.ProcessorComponentInfo;
import org.apache.cocoon.core.container.CoreServiceManager;

public class CocoonServiceManager
extends CoreServiceManager {
    private Map sitemapConfigurationHolders = new HashMap(15);
    private ProcessorComponentInfo info;

    public CocoonServiceManager(ServiceManager parent) {
        super(parent);
        ProcessorComponentInfo parentInfo = null;
        if (parent != null) {
            try {
                parentInfo = (ProcessorComponentInfo)parent.lookup(ProcessorComponentInfo.ROLE);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this.info = new ProcessorComponentInfo(parentInfo);
    }

    public void addComponent(String role, String clazz, Configuration config) throws ConfigurationException {
        super.addComponent(role, clazz, config);
        this.info.componentAdded(role, clazz, config);
    }

    public void addRoleAlias(String existingRole, String newRole) throws ServiceException {
        super.addRoleAlias(existingRole, newRole);
        this.info.roleAliased(existingRole, newRole);
    }

    public void initialize() throws Exception {
        this.info.lock();
        this.addInstance(ProcessorComponentInfo.ROLE, this.info);
        super.initialize();
    }

    protected void initialize(String role, Object component) throws ServiceException {
        super.initialize(role, component);
        if (null != component && component instanceof SitemapConfigurable) {
            SitemapConfigurationHolder holder = (SitemapConfigurationHolder)this.sitemapConfigurationHolders.get(role);
            if (null == holder) {
                holder = new DefaultSitemapConfigurationHolder(role, this.roleManager);
                this.sitemapConfigurationHolders.put(role, holder);
            }
            try {
                ((SitemapConfigurable)component).configure(holder);
            }
            catch (ConfigurationException ce) {
                throw new ServiceException(role, "Exception during setup of SitemapConfigurable.", (Throwable)ce);
            }
        }
    }
}

