/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.container;

import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;

public class ComponentContext
extends DefaultContext {
    protected static final String OBJECT_MODEL_KEY_PREFIX = "object-model.";

    public ComponentContext(Map contextData, Context parent) {
        super(contextData, parent);
    }

    public ComponentContext(Map contextData) {
        super(contextData);
    }

    public ComponentContext(Context parent) {
        super(parent);
    }

    public ComponentContext() {
    }

    public Object get(Object key) throws ContextException {
        String stringKey;
        if ("object-model".equals(key)) {
            Environment env = EnvironmentHelper.getCurrentEnvironment();
            if (env == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            return env.getObjectModel();
        }
        if ("sitemap-service-manager".equals(key)) {
            ServiceManager manager = EnvironmentHelper.getSitemapServiceManager();
            if (manager == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            return manager;
        }
        if (key instanceof String && (stringKey = (String)key).startsWith(OBJECT_MODEL_KEY_PREFIX)) {
            String objectKey;
            Environment env = EnvironmentHelper.getCurrentEnvironment();
            if (env == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            Map objectModel = env.getObjectModel();
            Object o = objectModel.get(objectKey = stringKey.substring(OBJECT_MODEL_KEY_PREFIX.length()));
            if (o == null) {
                String message = "Unable to locate " + key;
                throw new ContextException(message);
            }
            return o;
        }
        return super.get(key);
    }
}

