/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.core.container.RoleManager;
import org.apache.cocoon.environment.internal.EnvironmentHelper;

public final class DefaultSitemapConfigurationHolder
implements SitemapConfigurationHolder {
    private final String role;
    private final RoleManager roleManager;
    private Map preparedConfigurations;

    public DefaultSitemapConfigurationHolder(String role, RoleManager manager) {
        this.role = role;
        this.roleManager = manager;
    }

    protected Map convert(Configuration[] configs, int index) {
        Map<String, ChainedConfiguration> sitemapComponentConfigurations;
        Configuration[] childs = configs[index].getChildren();
        if (null != childs && childs.length > 0) {
            sitemapComponentConfigurations = index == configs.length - 1 ? new HashMap<String, ChainedConfiguration>(12) : new HashMap(this.convert(configs, index + 1));
            for (int m = 0; m < childs.length; ++m) {
                String r = this.roleManager.getRoleForName(childs[m].getName());
                sitemapComponentConfigurations.put(r, new ChainedConfiguration(childs[m], (ChainedConfiguration)sitemapComponentConfigurations.get(r)));
            }
        } else {
            sitemapComponentConfigurations = index == configs.length - 1 ? Collections.EMPTY_MAP : this.convert(configs, index + 1);
        }
        return sitemapComponentConfigurations;
    }

    public ChainedConfiguration getConfiguration() {
        Map confs = this.convert(EnvironmentHelper.getCurrentProcessor().getComponentConfigurations(), 0);
        return confs == null ? null : confs.get(this.role);
    }

    public Object getPreparedConfiguration() {
        ChainedConfiguration conf;
        if (null != this.preparedConfigurations && null != (conf = this.getConfiguration())) {
            return this.preparedConfigurations.get(conf);
        }
        return null;
    }

    public void setPreparedConfiguration(ChainedConfiguration configuration, Object preparedConfig) {
        if (null == this.preparedConfigurations) {
            this.preparedConfigurations = new HashMap(5);
        }
        this.preparedConfigurations.put(configuration, preparedConfig);
    }
}

