/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import org.apache.avalon.framework.logger.Logger;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class JSErrorReporter
implements ErrorReporter {
    private Logger logger;

    public JSErrorReporter(Logger logger) {
        this.logger = logger;
    }

    public void error(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.error", message, sourceName, line, lineSrc, column);
        System.err.println(errMsg);
        this.logger.error(errMsg);
    }

    public void warning(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.warning", message, sourceName, line, lineSrc, column);
        System.err.println(errMsg);
        this.logger.warn(errMsg);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.error", message, sourceName, line, lineSrc, column);
        System.err.println(errMsg);
        return new EvaluatorException(errMsg);
    }

    String getErrorMessage(String type, String message, String sourceName, int line, String lineSource, int column) {
        if (line > 0) {
            if (sourceName != null) {
                Object[] errArgs = new Object[]{sourceName, new Integer(line), message};
                return ToolErrorReporter.getMessage((String)"msg.format3", (Object[])errArgs);
            }
            Object[] errArgs = new Object[]{new Integer(line), message};
            return ToolErrorReporter.getMessage((String)"msg.format2", (Object[])errArgs);
        }
        Object[] errArgs = new Object[]{message};
        return ToolErrorReporter.getMessage((String)"msg.format1", (Object[])errArgs);
    }
}

