/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.input.ModuleHolder;

public abstract class AbstractMetaModule
extends AbstractInputModule
implements Serviceable,
Disposable {
    protected ServiceManager manager;
    protected ServiceSelector inputSelector;
    protected InputModule input;
    protected String defaultInput = "request-param";
    protected Configuration inputConf;
    protected boolean initialized = false;
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private static final String[] OPNAME = new String[]{"GET_VALUE", "GET_VALUES", "GET_NAMES"};

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public synchronized void lazy_initialize() {
        block7: {
            try {
                if (!this.initialized) {
                    this.inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (this.inputSelector != null && this.inputSelector instanceof ThreadSafe) {
                        if (this.defaultInput != null) {
                            this.input = this.obtainModule(this.defaultInput);
                        }
                    } else if (!(this.inputSelector instanceof ThreadSafe)) {
                        this.manager.release((Object)this.inputSelector);
                        this.inputSelector = null;
                    }
                    this.initialized = true;
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                this.getLogger().error("A problem occurred setting up input modules :'" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.inputSelector != null) {
            if (this.input != null) {
                this.inputSelector.release((Object)this.input);
            }
            this.manager.release((Object)this.inputSelector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputModule obtainModule(String type) {
        ServiceSelector inputSelector = this.inputSelector;
        InputModule module = null;
        try {
            block9: {
                try {
                    if (inputSelector == null) {
                        inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    if (inputSelector.isSelectable((Object)type)) {
                        if (type != null && inputSelector.isSelectable((Object)type)) {
                            module = (InputModule)inputSelector.select((Object)type);
                        }
                        if (!(module instanceof ThreadSafe)) {
                            inputSelector.release(module);
                            module = null;
                        }
                    }
                    if (type == null || module != null || !this.getLogger().isWarnEnabled()) break block9;
                    this.getLogger().warn("A problem occurred setting up '" + type + "': Selector is " + (inputSelector != null ? "not " : "") + "null, Component is " + (inputSelector != null && inputSelector.isSelectable((Object)type) ? "known" : "unknown"));
                }
                catch (ServiceException ce) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                    }
                    Object var6_5 = null;
                    if (this.inputSelector != null) return module;
                    this.manager.release((Object)inputSelector);
                    return module;
                }
            }
            Object var6_4 = null;
            if (this.inputSelector != null) return module;
            this.manager.release((Object)inputSelector);
            return module;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Object)inputSelector);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseModule(InputModule module) {
        ServiceSelector inputSelector = this.inputSelector;
        if (module == null) return;
        try {
            try {
                if (inputSelector == null) {
                    inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                }
                inputSelector.release((Object)module);
                module = null;
            }
            catch (ServiceException ce) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                }
                Object var5_4 = null;
                if (this.inputSelector != null) return;
                this.manager.release((Object)inputSelector);
                return;
            }
            Object var5_3 = null;
            if (this.inputSelector != null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Object)inputSelector);
            throw throwable;
        }
        this.manager.release((Object)inputSelector);
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object getValue(String attr, Map objectModel, ModuleHolder holder) throws ConfigurationException {
        return this.getValue(attr, objectModel, holder.input, holder.name, holder.config);
    }

    protected Object getValue(String attr, Map objectModel, ModuleHolder staticHolder, ModuleHolder dynamicHolder) throws ConfigurationException {
        return this.getValue(attr, objectModel, staticHolder.input, staticHolder.name, dynamicHolder.config);
    }

    protected Object[] getValues(String attr, Map objectModel, ModuleHolder holder) throws ConfigurationException {
        return this.getValues(attr, objectModel, holder.input, holder.name, holder.config);
    }

    protected Object[] getValues(String attr, Map objectModel, ModuleHolder staticHolder, ModuleHolder dynamicHolder) throws ConfigurationException {
        return this.getValues(attr, objectModel, staticHolder.input, staticHolder.name, dynamicHolder.config);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(int op, String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        Object[] value;
        ServiceSelector cs;
        block23: {
            cs = this.inputSelector;
            value = null;
            String name = null;
            InputModule input = null;
            Configuration conf = null;
            boolean release = false;
            try {
                boolean useDynamic;
                if (cs == null) {
                    try {
                        cs = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    catch (ServiceException e) {
                        throw new ConfigurationException("Could not find MetaModule's module selector", (Throwable)e);
                    }
                }
                if (dynamicMod == null && dynamicModName == null) {
                    useDynamic = false;
                    input = staticMod;
                    name = staticModName;
                    conf = staticModConf;
                } else {
                    useDynamic = true;
                    input = dynamicMod;
                    name = dynamicModName;
                    conf = dynamicModConf;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("MetaModule performing op " + OPNAME[op] + " on " + (useDynamic ? "dynamically" : "statically") + " " + (input == null ? "created" : "assigned") + " module '" + name + "', using config " + dynamicModConf);
                }
                if (input == null) {
                    if (cs.isSelectable((Object)name)) {
                        release = true;
                        try {
                            input = (InputModule)cs.select((Object)name);
                        }
                        catch (ServiceException e) {
                            throw new ConfigurationException("MetaModule unable to create " + (useDynamic ? "dynamically" : "statically") + " specified internal module '" + name + "'", (Throwable)e);
                        }
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("No such InputModule: " + name);
                    }
                }
                switch (op) {
                    case 0: {
                        value = input.getAttribute(attr, conf, objectModel);
                        break;
                    }
                    case 1: {
                        value = input.getAttributeValues(attr, conf, objectModel);
                        break;
                    }
                    case 2: {
                        value = input.getAttributeNames(conf, objectModel);
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("using " + name + " as " + input + " for " + op + " (" + attr + ") and " + conf + " gives " + value);
                }
                Object var19_19 = null;
                if (!release) break block23;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (release) {
                    cs.release((Object)input);
                }
                if (this.inputSelector == null) {
                    this.manager.release((Object)cs);
                }
                throw throwable;
            }
            cs.release((Object)input);
        }
        if (this.inputSelector == null) {
            this.manager.release((Object)cs);
        }
        return value;
    }
}

