/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.modules.input.InputModule;

public class InputModuleHelper {
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private Map inputModules;
    private ServiceManager serviceManager;
    private ServiceSelector serviceInputSelector;

    private InputModule getInputModule(String name) throws CascadingRuntimeException {
        if (this.inputModules == null) {
            throw new RuntimeException("ModuleHelper is not setup correctly.");
        }
        InputModule module = (InputModule)this.inputModules.get(name);
        if (module == null) {
            try {
                if (this.serviceInputSelector.isSelectable((Object)name)) {
                    module = (InputModule)this.serviceInputSelector.select((Object)name);
                }
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Unable to lookup input module " + name, (Throwable)e);
            }
            if (module == null) {
                throw new RuntimeException("No such InputModule: " + name);
            }
            this.inputModules.put(name, module);
        }
        return module;
    }

    private Object get(int op, String name, String attr, Map objectModel, Configuration conf) throws CascadingRuntimeException {
        Object[] value = null;
        InputModule input = this.getInputModule(name);
        try {
            switch (op) {
                case 0: {
                    value = input.getAttribute(attr, conf, objectModel);
                    break;
                }
                case 1: {
                    value = input.getAttributeValues(attr, conf, objectModel);
                    break;
                }
                case 2: {
                    value = input.getAttributeNames(conf, objectModel);
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error accessing attribute '" + attr + "' from input module '" + name + "'. " + e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private Object get(int op, String name, String attr, Map objectModel) throws RuntimeException {
        return this.get(op, name, attr, objectModel, null);
    }

    public void setup(ServiceManager manager) throws RuntimeException {
        this.inputModules = new HashMap();
        this.serviceManager = manager;
        try {
            this.serviceInputSelector = (ServiceSelector)this.serviceManager.lookup(INPUT_MODULE_SELECTOR);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not obtain selector for InputModule.", (Throwable)e);
        }
    }

    public Object getAttribute(Map objectModel, Configuration conf, String module, String name, Object deflt) throws RuntimeException {
        Object result = this.get(0, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object getAttribute(Map objectModel, String module, String name, Object deflt) throws RuntimeException {
        return this.getAttribute(objectModel, null, module, name, deflt);
    }

    public Object[] getAttributeValues(Map objectModel, Configuration conf, String module, String name, Object[] deflt) throws RuntimeException {
        Object[] result = (Object[])this.get(1, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object[] getAttributeValues(Map objectModel, String module, String name, Object[] deflt) throws RuntimeException {
        return this.getAttributeValues(objectModel, null, module, name, deflt);
    }

    public Iterator getAttributeNames(Map objectModel, Configuration conf, String module) throws RuntimeException {
        return (Iterator)this.get(2, module, null, objectModel);
    }

    public Iterator getAttributeNames(Map objectModel, String module) throws RuntimeException {
        return this.getAttributeNames(objectModel, null, module);
    }

    public void releaseAll() throws RuntimeException {
        if (this.inputModules != null && this.serviceManager != null) {
            try {
                Iterator iter = this.inputModules.keySet().iterator();
                while (iter.hasNext()) {
                    this.serviceInputSelector.release(this.inputModules.get(iter.next()));
                }
                this.inputModules = null;
                this.serviceManager.release((Object)this.serviceInputSelector);
                this.serviceManager = null;
                this.inputModules = null;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Could not release InputModules.", (Throwable)e);
            }
        }
    }
}

