/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;

public class SimpleMappingMetaModule
extends AbstractMetaModule
implements ThreadSafe {
    String prefix = null;
    String suffix = null;
    String rmPrefix = null;
    String rmSuffix = null;
    Mapping mapping = null;

    public void configure(Configuration config) throws ConfigurationException {
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
        this.prefix = config.getChild("prefix").getValue(null);
        this.suffix = config.getChild("suffix").getValue(null);
        this.rmPrefix = config.getChild("rm-prefix").getValue(null);
        this.rmSuffix = config.getChild("rm-suffix").getValue(null);
        this.mapping = new Mapping(config);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        String rmPrefix = this.rmPrefix;
        String rmSuffix = this.rmSuffix;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
            rmPrefix = modeConf.getChild("rm-prefix").getValue(null);
            rmSuffix = modeConf.getChild("rm-suffix").getValue(null);
        }
        if (rmPrefix != null && name.startsWith(rmPrefix)) {
            name = name.substring(rmPrefix.length());
        }
        if (rmSuffix != null && name.endsWith(rmSuffix)) {
            name = name.substring(0, name.length() - rmSuffix.length());
        }
        String param = mapping.mapTo(name);
        if (prefix != null) {
            param = prefix + param;
        }
        if (suffix != null) {
            param = param + suffix;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("mapping ['" + name + "'] to ['" + param + "']");
        }
        Object res = this.getValue(param, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getting for real attribute ['" + param + "'] value: " + res);
        }
        return res;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        String rmPrefix = this.rmPrefix;
        String rmSuffix = this.rmSuffix;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
            rmPrefix = modeConf.getChild("rm-prefix").getValue(null);
            rmSuffix = modeConf.getChild("rm-suffix").getValue(null);
        }
        if (rmPrefix != null && name.startsWith(rmPrefix)) {
            name = name.substring(rmPrefix.length());
        }
        if (rmSuffix != null && name.endsWith(rmSuffix)) {
            name = name.substring(0, name.length() - rmSuffix.length());
        }
        String param = mapping.mapTo(name);
        if (prefix != null) {
            param = prefix + param;
        }
        if (suffix != null) {
            param = param + suffix;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("mapping ['" + name + "'] to ['" + param + "']");
        }
        Object[] res = this.getValues(param, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getting for real attribute ['" + param + "'] value: " + res);
        }
        return res;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        Mapping mapping = this.mapping;
        String prefix = this.prefix;
        String suffix = this.suffix;
        String rmPrefix = this.rmPrefix;
        String rmSuffix = this.rmSuffix;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
            mapping = new Mapping(modeConf);
            prefix = modeConf.getChild("prefix").getValue(null);
            suffix = modeConf.getChild("suffix").getValue(null);
            rmPrefix = modeConf.getChild("rm-prefix").getValue(null);
            rmSuffix = modeConf.getChild("rm-suffix").getValue(null);
        }
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        HashSet<String> set = new HashSet<String>();
        while (names.hasNext()) {
            String param = (String)names.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("reverse mapping starts with ['" + param + "']");
            }
            if (prefix != null) {
                if (!param.startsWith(prefix)) continue;
                param = param.substring(prefix.length());
            }
            if (suffix != null) {
                if (!param.endsWith(suffix)) continue;
                param = param.substring(0, param.length() - suffix.length());
            }
            if (param.length() < 1) continue;
            String newName = mapping.mapFrom(param);
            if (rmPrefix != null) {
                newName = rmPrefix + newName;
            }
            if (rmSuffix != null) {
                newName = newName + rmSuffix;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("reverse mapping results in ['" + newName + "']");
            }
            set.add(newName);
        }
        return set.iterator();
    }

    protected class Mapping {
        Map toMap = null;
        Map fromMap = null;

        public Mapping() {
        }

        public Mapping(Map to, Map from) {
            this.toMap = to;
            this.fromMap = from;
        }

        public Mapping(Configuration config) throws ConfigurationException {
            Configuration[] mappings = config.getChildren("mapping");
            if (mappings != null) {
                if (this.toMap == null) {
                    this.toMap = new HashMap();
                }
                if (this.fromMap == null) {
                    this.fromMap = new HashMap();
                }
                for (int i = 0; i < mappings.length; ++i) {
                    String in = mappings[i].getAttribute("in", null);
                    String out = mappings[i].getAttribute("out", null);
                    if (in == null || out == null) continue;
                    this.toMap.put(in, out);
                    this.fromMap.put(out, in);
                }
            }
        }

        private String mapIt(Map map, String param) {
            String newParam = param;
            if (map != null) {
                newParam = map.get(param);
                if (!map.containsKey(param) || newParam == null) {
                    newParam = param;
                }
            }
            return newParam;
        }

        public String mapFrom(String param) {
            return this.mapIt(this.fromMap, param);
        }

        public String mapTo(String param) {
            return this.mapIt(this.toMap, param);
        }
    }
}

