/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public abstract class AbstractProcessingPipeline
extends AbstractLogEnabled
implements ProcessingPipeline,
Parameterizable,
Recyclable,
Serviceable {
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    protected Reader reader;
    protected Parameters readerParam;
    protected String readerSource;
    protected String readerMimeType;
    private boolean prepared;
    protected XMLConsumer lastConsumer;
    protected ServiceManager manager;
    protected ServiceManager newManager;
    protected Parameters configuration;
    protected Parameters parameters;
    protected long expires;
    protected long configuredExpires;
    protected int configuredOutputBufferSize;
    protected int outputBufferSize;
    protected Processor processor;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.newManager = manager;
    }

    public void setProcessorManager(ServiceManager manager) {
        this.newManager = manager;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.configuration = params;
        String expiresValue = params.getParameter("expires", null);
        if (expiresValue != null) {
            this.configuredExpires = this.parseExpires(expiresValue);
        }
        this.configuredOutputBufferSize = params.getParameterAsInteger("outputBufferSize", -1);
    }

    public void setup(Parameters params) {
        this.parameters = params;
        String expiresValue = params.getParameter("expires", null);
        this.expires = expiresValue != null ? this.parseExpires(expiresValue) : this.configuredExpires;
        this.outputBufferSize = params.getParameterAsInteger("outputBufferSize", this.configuredOutputBufferSize);
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void informBranchPoint() {
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot set generator '" + role + "' at " + this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set generator '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.generator = (Generator)this.newManager.lookup(Generator.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of generator '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot add transformer '" + role + "' at " + this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before adding transformer '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.transformers.add(this.newManager.lookup(Transformer.ROLE + '/' + role));
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of transformer '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. Cannot set serializer '" + role + "' at " + this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set serializer '" + role + "' at " + this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before setting serializer '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.serializer = (Serializer)this.newManager.lookup(Serializer.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of serializer '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.lastConsumer = this.serializer;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set reader '" + role + "' at " + this.getLocation(param));
        }
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot use reader '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.reader = (Reader)this.newManager.lookup(Reader.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of reader '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.readerSource = source;
        this.readerParam = param;
        this.readerMimeType = mimeType;
    }

    protected boolean checkPipeline() {
        if (this.generator == null && this.reader == null) {
            return false;
        }
        return this.generator == null || this.serializer != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.setup(this.processor.getSourceResolver(), environment.getObjectModel(), this.generatorSource, this.generatorParam);
            Iterator transformerItt = this.transformers.iterator();
            Iterator transformerSourceItt = this.transformerSources.iterator();
            Iterator transformerParamItt = this.transformerParams.iterator();
            while (transformerItt.hasNext()) {
                Transformer trans = (Transformer)transformerItt.next();
                trans.setup(this.processor.getSourceResolver(), environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
            }
            if (this.serializer instanceof SitemapModelComponent) {
                ((SitemapModelComponent)((Object)this.serializer)).setup(this.processor.getSourceResolver(), environment.getObjectModel(), this.serializerSource, this.serializerParam);
            }
        }
        catch (SAXException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        producer.setConsumer(consumer);
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        XMLProducer prev = this.generator;
        Iterator itt = this.transformers.iterator();
        while (itt.hasNext()) {
            Transformer next = (Transformer)itt.next();
            this.connect(environment, prev, next);
            prev = next;
        }
        this.connect(environment, prev, this.lastConsumer);
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (!this.prepared) {
            this.preparePipeline(environment);
        }
        if (this.expires != 0L) {
            Response res = ObjectModelHelper.getResponse(environment.getObjectModel());
            res.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            res.setHeader("Cache-Control", "max-age=" + this.expires / 1000L + ", public");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting a new Expires object for this resource");
            }
            environment.getObjectModel().put("expires", new Long(this.expires + System.currentTimeMillis()));
        }
        if (this.reader != null) {
            if (this.checkIfModified(environment, this.reader.getLastModified())) {
                return true;
            }
            return this.processReader(environment);
        }
        if (this.lastConsumer == null) {
            this.lastConsumer = this.serializer;
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    protected void preparePipeline(Environment environment) throws ProcessingException {
        this.processor = EnvironmentHelper.getCurrentProcessor();
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        if (this.prepared) {
            throw new ProcessingException("Duplicate preparePipeline call caught.");
        }
        if (this.reader != null) {
            this.setupReader(environment);
        } else {
            this.setupPipeline(environment);
        }
        this.prepared = true;
    }

    public void prepareInternal(Environment environment) throws ProcessingException {
        this.lastConsumer = null;
        this.preparePipeline(environment);
    }

    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        this.setMimeTypeForSerializer(environment);
        try {
            if (this.lastConsumer == null) {
                this.generator.generate();
            } else if (this.serializer.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.setOutputStream(os);
                this.generator.generate();
                environment.setContentLength(os.size());
                os.writeTo(environment.getOutputStream(0));
            } else {
                this.serializer.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.generator.generate();
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    protected void setupReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(this.processor.getSourceResolver(), environment.getObjectModel(), this.readerSource, this.readerParam);
            if (this.readerParam.isParameter("expires")) {
                this.expires = this.readerParam.getParameterAsLong("expires");
            }
        }
        catch (SAXException e) {
            throw new ProcessingException("Failed to execute reader pipeline.", e);
        }
        catch (ParameterException e) {
            throw new ProcessingException("Expires parameter needs to be of type long.", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to execute reader pipeline.", e);
        }
    }

    protected void setMimeTypeForReader(Environment environment) {
        if (this.readerMimeType != null) {
            environment.setContentType(this.readerMimeType);
        } else {
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            }
        }
    }

    protected void setMimeTypeForSerializer(Environment environment) throws ProcessingException {
        if (this.lastConsumer == null) {
            environment.setContentType("text/xml");
        } else if (this.serializerMimeType != null) {
            environment.setContentType(this.serializerMimeType);
        } else {
            String mimeType = this.serializer.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else {
                String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
                throw new ProcessingException(message);
            }
        }
    }

    protected boolean checkIfModified(Environment environment, long lastModified) throws ProcessingException {
        if (!environment.isResponseModified(lastModified)) {
            environment.setResponseIsNotModified();
            return true;
        }
        return false;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            this.setMimeTypeForReader(environment);
            if (this.reader.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.reader.setOutputStream(os);
                this.reader.generate();
                environment.setContentLength(os.size());
                os.writeTo(environment.getOutputStream(0));
            } else {
                this.reader.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.reader.generate();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    public void recycle() {
        this.prepared = false;
        if (this.reader != null) {
            this.newManager.release((Object)this.reader);
            this.reader = null;
            this.readerParam = null;
        }
        if (this.generator != null) {
            this.newManager.release((Object)this.generator);
            this.generator = null;
            this.generatorParam = null;
        }
        int size = this.transformers.size();
        for (int i = 0; i < size; ++i) {
            this.newManager.release(this.transformers.get(i));
        }
        this.transformers.clear();
        this.transformerParams.clear();
        this.transformerSources.clear();
        if (this.serializer != null) {
            this.newManager.release((Object)this.serializer);
            this.serializerParam = null;
        }
        this.serializer = null;
        this.parameters = null;
        this.processor = null;
        this.lastConsumer = null;
    }

    public boolean process(Environment environment, XMLConsumer consumer) throws ProcessingException {
        this.lastConsumer = consumer;
        if (this.reader != null) {
            throw new ProcessingException("Streaming of an internal pipeline is not possible with a reader.");
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    public SourceValidity getValidityForEventPipeline() {
        return null;
    }

    private long parseExpires(String expire) {
        StringTokenizer tokens = new StringTokenizer(expire);
        String current = tokens.nextToken();
        if (current.equals("modification")) {
            this.getLogger().warn("the \"modification\" keyword is not yet implemented. Assuming \"now\" as the base attribute");
            current = "now";
        }
        if (!current.equals("now") && !current.equals("access")) {
            this.getLogger().error("bad <base> attribute, Expires header will not be set");
            return -1L;
        }
        long number = 0L;
        long modifier = 0L;
        long expires = 0L;
        while (tokens.hasMoreTokens()) {
            current = tokens.nextToken();
            if (current.equals("plus")) {
                current = tokens.nextToken();
            }
            try {
                number = Long.parseLong(current);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().error("state violation: a number was expected here");
                return -1L;
            }
            try {
                current = tokens.nextToken();
            }
            catch (NoSuchElementException nsee) {
                this.getLogger().error("State violation: expecting a modifier but no one found: Expires header will not be set");
            }
            if (current.equals("years")) {
                modifier = 31536000000L;
            } else if (current.equals("months")) {
                modifier = 2592000000L;
            } else if (current.equals("weeks")) {
                modifier = 604800000L;
            } else if (current.equals("days")) {
                modifier = 86400000L;
            } else if (current.equals("hours")) {
                modifier = 3600000L;
            } else if (current.equals("minutes")) {
                modifier = 60000L;
            } else if (current.equals("seconds")) {
                modifier = 1000L;
            } else {
                this.getLogger().error("Bad modifier (" + current + "): ignoring expires configuration");
                return -1L;
            }
            expires += number * modifier;
        }
        return expires;
    }

    public String getKeyForEventPipeline() {
        return null;
    }

    protected String getLocation(Parameters param) {
        String value = null;
        if (param instanceof SitemapParameters) {
            value = ((SitemapParameters)param).getStatementLocation();
        }
        if (value == null) {
            value = "[unknown location]";
        }
        return value;
    }

    protected void handleException(Exception e) throws ProcessingException {
        if (e instanceof SocketException) {
            if (e.getMessage().indexOf("reset") > 0 || e.getMessage().indexOf("aborted") > 0 || e.getMessage().indexOf("connection abort") > 0) {
                throw new ConnectionResetException("Connection reset by peer", e);
            }
        } else if (e instanceof IOException) {
            if (e.getClass().getName().endsWith("ClientAbortException")) {
                throw new ConnectionResetException("Connection reset by peer", e);
            }
        } else if (e instanceof ProcessingException) {
            throw (ProcessingException)((Object)e);
        }
        throw new ProcessingException("Error executing pipeline.", e);
    }
}

