/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class VirtualProcessingPipeline
extends AbstractLogEnabled
implements ProcessingPipeline,
Recyclable,
Serviceable {
    private SourceResolver resolver;
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    private boolean prepared;
    protected XMLConsumer lastConsumer;
    protected ServiceManager manager;
    protected ServiceManager newManager;
    protected Processor processor;

    public VirtualProcessingPipeline(Context context) throws Exception {
        this.resolver = (EnvironmentHelper)context.get((Object)"env-helper");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.newManager = manager;
    }

    public void setProcessorManager(ServiceManager manager) {
        this.newManager = manager;
    }

    public void setup(Parameters params) {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void informBranchPoint() {
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot set generator '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.generator = (Generator)this.newManager.lookup(Generator.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of generator '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before adding transformer '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.transformers.add(this.newManager.lookup(Transformer.ROLE + '/' + role));
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of transformer '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. Cannot set serializer '" + role + "' at " + this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before setting serializer '" + role + "' at " + this.getLocation(param));
        }
        try {
            this.serializer = (Serializer)this.newManager.lookup(Serializer.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Lookup of serializer '" + role + "' failed at " + this.getLocation(param), ce);
        }
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.lastConsumer = this.serializer;
    }

    protected boolean checkPipeline() {
        return this.generator != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.setup(this.resolver, environment.getObjectModel(), this.generatorSource, this.generatorParam);
            Iterator transformerItt = this.transformers.iterator();
            Iterator transformerSourceItt = this.transformerSources.iterator();
            Iterator transformerParamItt = this.transformerParams.iterator();
            while (transformerItt.hasNext()) {
                Transformer trans = (Transformer)transformerItt.next();
                trans.setup(this.resolver, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
            }
            if (this.serializer instanceof SitemapModelComponent) {
                ((SitemapModelComponent)((Object)this.serializer)).setup(this.resolver, environment.getObjectModel(), this.serializerSource, this.serializerParam);
            }
        }
        catch (SAXException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not setup pipeline.", e);
        }
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        producer.setConsumer(consumer);
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        XMLProducer prev = this.generator;
        Iterator itt = this.transformers.iterator();
        while (itt.hasNext()) {
            Transformer next = (Transformer)itt.next();
            this.connect(environment, prev, next);
            prev = next;
        }
        this.connect(environment, prev, this.lastConsumer);
    }

    protected void preparePipeline(Environment environment) throws ProcessingException {
        this.processor = EnvironmentHelper.getCurrentProcessor();
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        if (this.prepared) {
            throw new ProcessingException("Duplicate preparePipeline call caught.");
        }
        this.setupPipeline(environment);
        this.prepared = true;
    }

    public void prepareInternal(Environment environment) throws ProcessingException {
        this.lastConsumer = null;
        this.preparePipeline(environment);
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        throw new UnsupportedOperationException();
    }

    public boolean process(Environment environment) throws ProcessingException {
        throw new UnsupportedOperationException();
    }

    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.generate();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    public void recycle() {
        this.prepared = false;
        if (this.generator != null) {
            this.newManager.release((Object)this.generator);
            this.generator = null;
            this.generatorParam = null;
        }
        int size = this.transformers.size();
        for (int i = 0; i < size; ++i) {
            this.newManager.release(this.transformers.get(i));
        }
        this.transformers.clear();
        this.transformerParams.clear();
        this.transformerSources.clear();
        if (this.serializer != null) {
            this.newManager.release((Object)this.serializer);
            this.serializerParam = null;
        }
        this.serializer = null;
        this.processor = null;
        this.lastConsumer = null;
    }

    public boolean process(Environment environment, XMLConsumer consumer) throws ProcessingException {
        this.lastConsumer = consumer;
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    public SourceValidity getValidityForEventPipeline() {
        return null;
    }

    public String getKeyForEventPipeline() {
        return null;
    }

    protected String getLocation(Parameters param) {
        String value = null;
        if (param instanceof SitemapParameters) {
            value = ((SitemapParameters)param).getStatementLocation();
        }
        if (value == null) {
            value = "[unknown location]";
        }
        return value;
    }
}

