/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.URIAbsolutizer;

public class ContextSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Contextualizable,
ThreadSafe,
URIAbsolutizer {
    protected Context envContext;
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.envContext = (Context)context.get((Object)"environment-context");
    }

    public Source getSource(String location, Map parameters) throws SourceException, MalformedURLException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            int pos = location.indexOf(":/");
            String path = location.substring(pos + 1);
            if (path.indexOf("../") != -1) {
                throw new MalformedURLException("Invalid path ('../' is not allowed) : " + path);
            }
            String actualPath = this.envContext.getRealPath(path);
            URL u = actualPath != null ? new File(actualPath).toURL() : this.envContext.getResource(path);
            if (u != null) {
                Source source = resolver.resolveURI(u.toExternalForm());
                return source;
            }
            try {
                String message = location + " could not be found. (possible context problem)";
                this.getLogger().info(message);
                throw new MalformedURLException(message);
            }
            catch (ServiceException se) {
                throw new SourceException("Unable to lookup source resolver.", (Throwable)se);
            }
        }
        finally {
            this.manager.release((Object)resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Source source) {
        if (null != source) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Releasing source " + source.getURI());
            }
            SourceResolver resolver = null;
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                resolver.release(source);
            }
            catch (ServiceException serviceException) {
            }
            finally {
                this.manager.release((Object)resolver);
            }
        }
    }

    public String absolutize(String baseURI, String location) {
        return SourceUtil.absolutize((String)baseURI, (String)location, (boolean)true);
    }
}

