/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.SitemapSourceInfo;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SitemapSource
extends AbstractLogEnabled
implements Source,
XMLizable {
    private SitemapSourceValidity validity;
    private final String systemId;
    private String systemIdForCaching;
    private final ServiceManager manager;
    private final Processor processor;
    private Processor.InternalPipelineDescription pipelineDescription;
    private final MutableEnvironmentFacade environment;
    private Source redirectSource;
    private SAXException exception;
    private boolean needsRefresh;
    private boolean processed;
    private final String protocol;
    private SourceResolver sourceResolver;
    private String mimeType;

    public SitemapSource(ServiceManager manager, String uri, Map parameters, Logger logger) throws MalformedURLException {
        Environment env = EnvironmentHelper.getCurrentEnvironment();
        if (env == null) {
            throw new MalformedURLException("The cocoon protocol can not be used outside an environment.");
        }
        this.manager = manager;
        this.enableLogging(logger);
        SitemapSourceInfo info = SitemapSourceInfo.parseURI(env, uri);
        this.protocol = info.protocol;
        this.processor = info.processFromRoot ? EnvironmentHelper.getCurrentProcessor().getRootProcessor() : EnvironmentHelper.getCurrentProcessor();
        EnvironmentWrapper wrapper = new EnvironmentWrapper(env, info, logger);
        this.environment = new MutableEnvironmentFacade(wrapper);
        if (null != parameters) {
            this.environment.getObjectModel().put("parent-context", parameters);
        } else {
            this.environment.getObjectModel().remove("parent-context");
        }
        this.systemId = info.systemId;
        this.validity = new SitemapSourceValidity();
        this.init();
    }

    public String getScheme() {
        return this.protocol;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException, SourceException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw new SourceException("Cannot get input stream for " + this.getURI(), (Throwable)this.exception);
        }
        if (this.redirectSource != null) {
            return this.redirectSource.getInputStream();
        }
        try {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.environment.setOutputStream(os);
                EnvironmentHelper.enterProcessor(this.pipelineDescription.lastProcessor, this.manager, this.environment);
                try {
                    this.pipelineDescription.processingPipeline.process(this.environment);
                }
                finally {
                    EnvironmentHelper.leaveProcessor();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                Object var4_6 = null;
                this.environment.setOutputStream(null);
                this.needsRefresh = true;
                return byteArrayInputStream;
            }
            catch (ResourceNotFoundException e) {
                throw new SourceNotFoundException("Exception during processing of " + this.systemId, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new SourceException("Exception during processing of " + this.systemId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.environment.setOutputStream(null);
            this.needsRefresh = true;
            throw throwable;
        }
    }

    public String getURI() {
        return this.systemIdForCaching;
    }

    public boolean exists() {
        return true;
    }

    public SourceValidity getValidity() {
        return this.validity;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void refresh() {
        this.reset();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        block13: {
            this.systemIdForCaching = this.systemId;
            try {
                this.environment.startingProcessing();
                this.processed = true;
                this.pipelineDescription = this.processor.buildPipeline(this.environment);
                this.environment.setURI(this.pipelineDescription.prefix, this.pipelineDescription.uri);
                String redirectURL = this.environment.getRedirectURL();
                if (redirectURL == null) {
                    EnvironmentHelper.enterProcessor(this.pipelineDescription.lastProcessor, this.manager, this.environment);
                    try {
                        this.pipelineDescription.processingPipeline.prepareInternal(this.environment);
                        this.validity.set(this.pipelineDescription.processingPipeline.getValidityForEventPipeline());
                        String eventPipelineKey = this.pipelineDescription.processingPipeline.getKeyForEventPipeline();
                        this.mimeType = this.environment.getContentType();
                        if (eventPipelineKey != null) {
                            StringBuffer buffer = new StringBuffer(this.systemId);
                            if (this.systemId.indexOf(63) == -1) {
                                buffer.append('?');
                            } else {
                                buffer.append('&');
                            }
                            buffer.append("pipelinehash=");
                            buffer.append(eventPipelineKey);
                            this.systemIdForCaching = buffer.toString();
                        } else {
                            this.systemIdForCaching = this.systemId;
                        }
                        break block13;
                    }
                    finally {
                        EnvironmentHelper.leaveProcessor();
                    }
                }
                if (redirectURL.indexOf(":") == -1) {
                    redirectURL = this.protocol + ":/" + redirectURL;
                }
                if (this.sourceResolver == null) {
                    this.sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                }
                this.redirectSource = this.sourceResolver.resolveURI(redirectURL);
                this.validity.set(this.redirectSource.getValidity());
                this.mimeType = this.redirectSource.getMimeType();
            }
            catch (SAXException e) {
                this.reset();
                this.exception = e;
            }
            catch (Exception e) {
                this.reset();
                this.exception = new SAXException("Could not get sitemap source " + this.systemId, e);
            }
        }
        this.needsRefresh = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toSAX(ContentHandler contentHandler) throws SAXException {
        block12: {
            if (this.needsRefresh) {
                this.refresh();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                if (this.redirectSource != null) {
                    SourceUtil.parse(this.manager, this.redirectSource, contentHandler);
                    break block12;
                }
                XMLConsumer consumer = contentHandler instanceof XMLConsumer ? (XMLConsumer)((Object)contentHandler) : (contentHandler instanceof LexicalHandler ? new ContentHandlerWrapper(contentHandler, (LexicalHandler)((Object)contentHandler)) : new ContentHandlerWrapper(contentHandler));
                EnvironmentHelper.enterProcessor(this.pipelineDescription.lastProcessor, this.manager, this.environment);
                try {
                    this.pipelineDescription.processingPipeline.process(this.environment, EnvironmentHelper.createEnvironmentAwareConsumer(consumer));
                }
                finally {
                    EnvironmentHelper.leaveProcessor();
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
            finally {
                this.needsRefresh = true;
            }
        }
    }

    private void reset() {
        if (this.pipelineDescription != null) {
            this.pipelineDescription.release();
            this.pipelineDescription = null;
        }
        if (this.processed) {
            this.processed = false;
            this.environment.finishingProcessing();
        }
        if (this.redirectSource != null) {
            this.sourceResolver.release(this.redirectSource);
            this.redirectSource = null;
        }
        this.validity.set(null);
        this.environment.reset();
        this.exception = null;
        this.needsRefresh = true;
    }

    public void recycle() {
        this.validity = new SitemapSourceValidity();
        this.reset();
        if (this.sourceResolver != null) {
            this.manager.release((Object)this.sourceResolver);
            this.sourceResolver = null;
        }
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    public static final class SitemapSourceValidity
    implements SourceValidity {
        private SourceValidity nested_validity = null;

        private SitemapSourceValidity() {
        }

        private void set(SourceValidity validity) {
            this.nested_validity = validity;
        }

        public int isValid() {
            return this.nested_validity != null ? this.nested_validity.isValid() : -1;
        }

        public int isValid(SourceValidity validity) {
            if (validity instanceof SitemapSourceValidity) {
                return this.nested_validity != null ? this.nested_validity.isValid(((SitemapSourceValidity)validity).getNestedValidity()) : -1;
            }
            return -1;
        }

        public SourceValidity getNestedValidity() {
            return this.nested_validity;
        }
    }
}

