/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.net.MalformedURLException;
import org.apache.cocoon.environment.Environment;

public final class SitemapSourceInfo {
    public boolean rawMode;
    public String protocol;
    public String requestURI;
    public String systemId;
    public String view;
    public String prefix;
    public String queryString;
    public String uri;
    public boolean processFromRoot;

    public static SitemapSourceInfo parseURI(Environment env, String sitemapURI) throws MalformedURLException {
        String tmp;
        int index;
        SitemapSourceInfo info = new SitemapSourceInfo();
        info.rawMode = false;
        int position = sitemapURI.indexOf(58) + 1;
        if (position != 0) {
            info.protocol = sitemapURI.substring(0, position - 1);
            if (sitemapURI.startsWith("raw:", position)) {
                position += 4;
                info.rawMode = true;
            }
        } else {
            throw new MalformedURLException("No protocol found for sitemap source in " + sitemapURI);
        }
        if (sitemapURI.startsWith("//", position)) {
            position += 2;
            info.prefix = "";
            info.processFromRoot = true;
        } else if (sitemapURI.startsWith("/", position)) {
            ++position;
            info.prefix = env.getURIPrefix();
            info.processFromRoot = false;
        } else {
            throw new MalformedURLException("Malformed cocoon URI: " + sitemapURI);
        }
        int queryStringPos = sitemapURI.indexOf(63, position);
        if (queryStringPos != -1) {
            info.queryString = sitemapURI.substring(queryStringPos + 1);
            info.uri = sitemapURI.substring(position, queryStringPos);
        } else if (position > 0) {
            info.uri = sitemapURI.substring(position);
        }
        info.view = null;
        info.view = info.queryString != null ? ((index = info.queryString.indexOf("cocoon-view")) != -1 && (index == 0 || info.queryString.charAt(index - 1) == '&') && info.queryString.length() > index + "cocoon-view".length() && info.queryString.charAt(index + "cocoon-view".length()) == '=' ? ((index = (tmp = info.queryString.substring(index + "cocoon-view".length() + 1)).indexOf(38)) != -1 ? tmp.substring(0, index) : tmp) : env.getView()) : env.getView();
        info.requestURI = info.prefix + info.uri;
        StringBuffer buffer = new StringBuffer(info.protocol);
        buffer.append("://").append(info.requestURI);
        if (info.queryString != null) {
            buffer.append('?').append(info.queryString);
        }
        info.systemId = buffer.toString();
        return info;
    }
}

