/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;

public abstract class AbstractProcessingNodeBuilder
extends AbstractLogEnabled
implements ProcessingNodeBuilder {
    protected TreeBuilder treeBuilder;
    protected ServiceManager manager;

    public void setBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.manager = treeBuilder.getBuiltProcessorManager();
    }

    protected boolean hasParameters() {
        return true;
    }

    protected Map getParameters(Configuration config) throws ConfigurationException {
        Configuration[] children = config.getChildren("parameter");
        if (children.length == 0) {
            return new SitemapParameters.ExtendedHashMap(config);
        }
        SitemapParameters.ExtendedHashMap params = new SitemapParameters.ExtendedHashMap(config, children.length + 1);
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(VariableResolverFactory.getResolver(name, this.manager), VariableResolverFactory.getResolver(value, this.manager));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + " at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
        }
        return params;
    }

    protected void checkNamespace(Configuration config) throws ConfigurationException {
        if (!this.treeBuilder.getNamespace().equals(config.getNamespace())) {
            String msg = "Invalid namespace '" + config.getNamespace() + "' at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
    }
}

