/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.impl.SitemapSourceInfo;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ForwardRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.environment.internal.ForwardEnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.sitemap.SitemapExecutor;

public class ConcreteTreeProcessor
extends AbstractLogEnabled
implements Processor {
    private ServiceManager manager;
    private TreeProcessor wrappingProcessor;
    private List disposableNodes;
    private ProcessingNode rootNode;
    private Configuration componentConfigurations;
    private int requestCount;
    private SitemapExecutor sitemapExecutor;

    public ConcreteTreeProcessor(TreeProcessor wrappingProcessor, SitemapExecutor sitemapExecutor) {
        this.wrappingProcessor = wrappingProcessor;
        this.sitemapExecutor = sitemapExecutor;
    }

    public void setProcessorData(ServiceManager manager, ProcessingNode rootNode, List disposableNodes) {
        if (this.rootNode != null) {
            throw new IllegalStateException("setProcessorData() can only be called once");
        }
        this.manager = manager;
        this.rootNode = rootNode;
        this.disposableNodes = disposableNodes;
    }

    public void setComponentConfigurations(Configuration componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
    }

    public Configuration[] getComponentConfigurations() {
        if (this.componentConfigurations == null) {
            if (this.wrappingProcessor.parent != null) {
                return this.wrappingProcessor.parent.getComponentConfigurations();
            }
            return null;
        }
        if (this.wrappingProcessor.parent == null) {
            return new Configuration[]{this.componentConfigurations};
        }
        Configuration[] parentArray = this.wrappingProcessor.parent.getComponentConfigurations();
        Configuration[] newArray = new Configuration[parentArray.length + 1];
        System.arraycopy(parentArray, 0, newArray, 1, parentArray.length);
        newArray[0] = this.componentConfigurations;
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForDisposal() {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            --this.requestCount;
        }
        if (this.requestCount < 0) {
            this.dispose();
        }
    }

    public TreeProcessor getWrappingProcessor() {
        return this.wrappingProcessor;
    }

    public Processor getRootProcessor() {
        return this.wrappingProcessor.getRootProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        context.enableLogging(this.getLogger());
        try {
            boolean bl = this.process(environment, context);
            return bl;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Processor.InternalPipelineDescription buildPipeline(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        try {
            if (this.process(environment, context)) {
                Processor.InternalPipelineDescription internalPipelineDescription = context.getInternalPipelineDescription(environment);
                return internalPipelineDescription;
            }
            Processor.InternalPipelineDescription internalPipelineDescription = null;
            return internalPipelineDescription;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            ++this.requestCount;
        }
        try {
            EnvironmentHelper.enterProcessor(this, this.manager, environment);
            Redirector oldRedirector = context.getRedirector();
            TreeProcessorRedirector redirector = new TreeProcessorRedirector(environment, context);
            this.setupLogger(redirector);
            context.setRedirector(redirector);
            context.service(this.manager);
            context.setLastProcessor(this);
            try {
                boolean success;
                boolean bl = success = this.rootNode.invoke(environment, context);
                return bl;
            }
            finally {
                EnvironmentHelper.leaveProcessor();
                context.setRedirector(oldRedirector);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ConcreteTreeProcessor concreteTreeProcessor2 = this;
            synchronized (concreteTreeProcessor2) {
                --this.requestCount;
            }
            if (this.requestCount >= 0) throw throwable;
            this.dispose();
            throw throwable;
        }
    }

    protected boolean handleCocoonRedirect(String uri, Environment environment, InvokeContext context) throws Exception {
        MutableEnvironmentFacade facade;
        MutableEnvironmentFacade mutableEnvironmentFacade = facade = environment instanceof MutableEnvironmentFacade ? (MutableEnvironmentFacade)environment : null;
        if (facade != null) {
            environment = facade.getDelegate();
        }
        boolean isRedirect = environment.getObjectModel().remove("cocoon:forward") == null;
        SitemapSourceInfo info = SitemapSourceInfo.parseURI(environment, uri);
        Environment newEnv = new ForwardEnvironmentWrapper(environment, info, this.getLogger());
        if (isRedirect) {
            ((EnvironmentWrapper)newEnv).setInternalRedirect(true);
        }
        if (facade != null) {
            facade.setDelegate((EnvironmentWrapper)newEnv);
            newEnv = facade;
        }
        ConcreteTreeProcessor processor = newEnv.getURIPrefix().equals("") ? ((TreeProcessor)this.getRootProcessor()).concreteProcessor : this;
        boolean result = processor.process(newEnv, context);
        if (facade != null) {
            newEnv = facade.getDelegate();
        }
        if (((EnvironmentWrapper)newEnv).getRedirectURL() != null) {
            environment.redirect(((EnvironmentWrapper)newEnv).getRedirectURL(), false, false);
        }
        return result;
    }

    public void dispose() {
        if (this.disposableNodes != null) {
            for (int i = this.disposableNodes.size() - 1; i > -1; --i) {
                ((Disposable)this.disposableNodes.get(i)).dispose();
            }
            this.disposableNodes = null;
        }
        this.rootNode = null;
        this.sitemapExecutor = null;
    }

    public SourceResolver getSourceResolver() {
        return this.wrappingProcessor.getSourceResolver();
    }

    public String getContext() {
        return this.wrappingProcessor.getContext();
    }

    public SitemapExecutor getSitemapExecutor() {
        return this.sitemapExecutor;
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    private class TreeProcessorRedirector
    extends ForwardRedirector {
        private InvokeContext context;

        public TreeProcessorRedirector(Environment env, InvokeContext context) {
            super(env);
            this.context = context;
        }

        protected void cocoonRedirect(String uri) throws IOException, ProcessingException {
            try {
                ConcreteTreeProcessor.this.handleCocoonRedirect(uri, this.env, this.context);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
        }
    }
}

