/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessorComponentInfo;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.core.container.CocoonServiceSelector;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class DefaultTreeBuilder
extends AbstractLogEnabled
implements TreeBuilder,
Contextualizable,
Serviceable,
Initializable,
Recyclable,
Disposable {
    protected Map attributes = new HashMap();
    private Context context;
    private ServiceManager manager;
    protected ConcreteTreeProcessor processor;
    protected String itsNamespace;
    private Context itsContext;
    private ServiceManager itsManager;
    private LifecycleHelper itsLifecycle;
    private ServiceSelector itsBuilders;
    protected ProcessorComponentInfo itsComponentInfo;
    protected ServiceManager parentProcessorManager;
    private List initializableNodes = new ArrayList();
    private List disposableNodes = new ArrayList();
    private List linkedBuilders = new ArrayList();
    private boolean canGetNode = false;
    private Map registeredNodes = new HashMap();

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
    }

    protected String getBuilderConfigURL() {
        return "resource://org/apache/cocoon/components/treeprocessor/sitemap-language.xml";
    }

    public void setParentProcessorManager(ServiceManager manager) {
        this.parentProcessorManager = manager;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected Context createContext(Configuration tree) throws Exception {
        return this.context;
    }

    protected ServiceManager createServiceManager(Context context, Configuration tree) throws Exception {
        return this.manager;
    }

    public void setProcessor(ConcreteTreeProcessor processor) {
        this.processor = processor;
    }

    public ConcreteTreeProcessor getProcessor() {
        return this.processor;
    }

    public ServiceManager getBuiltProcessorManager() {
        return this.itsManager;
    }

    public void registerNode(String name, ProcessingNode node) {
        this.registeredNodes.put(name, node);
    }

    public ProcessingNode getRegisteredNode(String name) {
        if (this.canGetNode) {
            return (ProcessingNode)this.registeredNodes.get(name);
        }
        throw new IllegalArgumentException("Categories are only available during buildNode()");
    }

    public ProcessingNodeBuilder createNodeBuilder(Configuration config) throws Exception {
        ProcessingNodeBuilder builder;
        String nodeName = config.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating node builder for " + nodeName);
        }
        try {
            builder = (ProcessingNodeBuilder)this.itsBuilders.select((Object)nodeName);
        }
        catch (ServiceException ce) {
            if (this.itsBuilders.isSelectable((Object)nodeName)) {
                throw ce;
            }
            String msg = "Unknown element '" + nodeName + "' at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
        builder.setBuilder(this);
        if (builder instanceof LinkedProcessingNodeBuilder) {
            this.linkedBuilders.add(builder);
        }
        return builder;
    }

    protected ProcessingNode createTree(Configuration tree) throws Exception {
        ProcessingNodeBuilder rootBuilder = this.createNodeBuilder(tree);
        return rootBuilder.buildNode(tree);
    }

    protected void linkNodes() throws Exception {
        Iterator iter = this.linkedBuilders.iterator();
        while (iter.hasNext()) {
            ((LinkedProcessingNodeBuilder)iter.next()).linkNode();
        }
    }

    public String getNamespace() {
        return this.itsNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingNode build(Configuration tree) throws Exception {
        Configuration config;
        this.itsNamespace = tree.getNamespace();
        this.itsContext = this.createContext(tree);
        this.itsManager = this.createServiceManager(this.itsContext, tree);
        this.itsComponentInfo = (ProcessorComponentInfo)this.itsManager.lookup(ProcessorComponentInfo.ROLE);
        this.itsLifecycle = new LifecycleHelper(this.getLogger(), this.itsContext, this.itsManager, null);
        CocoonServiceSelector selector = new CocoonServiceSelector(){

            protected String getComponentInstanceName() {
                return "node";
            }

            protected String getClassAttributeName() {
                return "builder";
            }
        };
        SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        String url = this.getBuilderConfigURL();
        try {
            Source src = resolver.resolveURI(url);
            try {
                SAXConfigurationHandler handler = new SAXConfigurationHandler();
                SourceUtil.toSAX(this.manager, src, null, (ContentHandler)handler);
                config = handler.getConfiguration();
            }
            finally {
                resolver.release(src);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not load TreeBuilder configuration from " + url, (Throwable)e);
        }
        finally {
            this.manager.release((Object)resolver);
        }
        LifecycleHelper.setupComponent((Object)selector, this.getLogger(), this.itsContext, this.itsManager, config.getChild("nodes", false), true);
        this.itsBuilders = selector;
        this.canGetNode = false;
        VariableResolverFactory.setDisposableCollector(this.disposableNodes);
        ProcessingNode result = this.createTree(tree);
        this.canGetNode = true;
        this.linkNodes();
        Iterator iter = this.initializableNodes.iterator();
        while (iter.hasNext()) {
            ((Initializable)iter.next()).initialize();
        }
        return result;
    }

    public List getDisposableNodes() {
        return this.disposableNodes;
    }

    public ProcessingNode setupNode(ProcessingNode node, Configuration config) throws Exception {
        if (node instanceof AbstractProcessingNode) {
            ((AbstractProcessingNode)node).setLocation(config.getLocation());
            ((AbstractProcessingNode)node).setSitemapExecutor(this.processor.getSitemapExecutor());
        }
        this.itsLifecycle.setupComponent(node, false);
        if (node instanceof ParameterizableProcessingNode) {
            Map params = this.getParameters(config);
            ((ParameterizableProcessingNode)node).setParameters(params);
        }
        if (node instanceof Initializable) {
            this.initializableNodes.add(node);
        }
        if (node instanceof Disposable) {
            this.disposableNodes.add(node);
        }
        return node;
    }

    protected Map getParameters(Configuration config) throws ConfigurationException {
        Configuration[] children = config.getChildren("parameter");
        if (children.length == 0) {
            return new SitemapParameters.ExtendedHashMap(config);
        }
        SitemapParameters.ExtendedHashMap params = new SitemapParameters.ExtendedHashMap(config, children.length + 1);
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(this.resolve(name), this.resolve(value));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + "' at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
        }
        return params;
    }

    public String getTypeForStatement(Configuration statement, String role) throws ConfigurationException {
        String type = statement.getAttribute("type", null);
        if (type == null) {
            type = this.itsComponentInfo.getDefaultType(role);
        }
        if (type == null) {
            throw new ConfigurationException("No default type exists for 'map:" + statement.getName() + "' at " + statement.getLocation());
        }
        ServiceSelector selector = null;
        try {
            selector = (ServiceSelector)this.itsManager.lookup(role + "Selector");
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Cannot get service selector for 'map:" + statement.getName() + "' at " + statement.getLocation(), (Throwable)e);
        }
        if (!selector.isSelectable((Object)type)) {
            throw new ConfigurationException("Type '" + type + "' does not exist for 'map:" + statement.getName() + "' at " + statement.getLocation());
        }
        this.itsManager.release((Object)selector);
        return type;
    }

    protected VariableResolver resolve(String expression) throws PatternException {
        return VariableResolverFactory.getResolver(expression, this.itsManager);
    }

    public void recycle() {
        this.attributes.clear();
        this.canGetNode = false;
        this.disposableNodes = new ArrayList();
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.parentProcessorManager = null;
        this.processor = null;
        this.itsNamespace = null;
        LifecycleHelper.dispose(this.itsBuilders);
        this.itsBuilders = null;
        this.itsLifecycle = null;
        this.itsManager = null;
        this.itsContext = null;
        this.registeredNodes.clear();
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.canGetNode = false;
        this.registeredNodes.clear();
        VariableResolverFactory.setDisposableCollector(null);
    }

    public void dispose() {
    }
}

