/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;

public class InvokeContext
extends AbstractLogEnabled
implements Serviceable,
Disposable {
    private List mapStack = new ArrayList();
    private HashMap nameToMap = new HashMap();
    private HashMap mapToName = new HashMap();
    private boolean isBuildingPipelineOnly;
    private ServiceManager currentManager;
    private ServiceManager pipelinesManager;
    protected String processingPipelineName;
    protected Map processingPipelineParameters;
    protected Map processingPipelineObjectModel;
    protected ProcessingPipeline processingPipeline;
    protected Processor.InternalPipelineDescription internalPipelineDescription;
    protected Processor lastProcessor;
    protected Redirector redirector;
    protected ServiceSelector pipelineSelector;

    public InvokeContext() {
        this.isBuildingPipelineOnly = false;
    }

    public boolean pipelineIsSet() {
        return this.processingPipeline != null;
    }

    public InvokeContext(boolean isBuildingPipelineOnly) {
        this.isBuildingPipelineOnly = isBuildingPipelineOnly;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.currentManager = manager;
        if (this.processingPipeline != null) {
            this.processingPipeline.setProcessorManager(manager);
        }
    }

    public void inform(String pipelineName, Map parameters, Map objectModel) {
        this.processingPipelineName = pipelineName;
        this.processingPipelineParameters = parameters;
        this.processingPipelineObjectModel = objectModel;
    }

    public ProcessingPipeline getProcessingPipeline() throws Exception {
        if (this.processingPipeline == null) {
            this.pipelinesManager = this.currentManager;
            this.pipelineSelector = (ServiceSelector)this.pipelinesManager.lookup(ProcessingPipeline.ROLE + "Selector");
            this.processingPipeline = (ProcessingPipeline)this.pipelineSelector.select((Object)this.processingPipelineName);
            this.processingPipeline.setProcessorManager(this.currentManager);
            this.processingPipeline.setup(VariableResolver.buildParameters(this.processingPipelineParameters, this, this.processingPipelineObjectModel));
        }
        return this.processingPipeline;
    }

    public void setInternalPipelineDescription(Processor.InternalPipelineDescription desc) {
        this.processingPipeline = desc.processingPipeline;
        this.pipelinesManager = desc.pipelineManager;
        this.lastProcessor = desc.lastProcessor;
        this.pipelineSelector = desc.pipelineSelector;
        this.internalPipelineDescription = new Processor.InternalPipelineDescription(this.processingPipeline, this.pipelineSelector, this.pipelinesManager);
        this.internalPipelineDescription.lastProcessor = this.lastProcessor;
        this.internalPipelineDescription.prefix = desc.prefix;
        this.internalPipelineDescription.uri = desc.uri;
    }

    public Processor.InternalPipelineDescription getInternalPipelineDescription(Environment env) {
        if (this.internalPipelineDescription == null) {
            this.internalPipelineDescription = new Processor.InternalPipelineDescription(this.processingPipeline, this.pipelineSelector, this.pipelinesManager);
            this.internalPipelineDescription.lastProcessor = this.lastProcessor;
            this.internalPipelineDescription.prefix = env.getURIPrefix();
            this.internalPipelineDescription.uri = env.getURI();
        }
        return this.internalPipelineDescription;
    }

    public void setLastProcessor(Processor p) {
        this.lastProcessor = p;
    }

    public final boolean isBuildingPipelineOnly() {
        return this.isBuildingPipelineOnly;
    }

    public final List getMapStack() {
        return this.mapStack;
    }

    public final Map getMapByAnchor(String anchor) {
        return (Map)this.nameToMap.get(anchor);
    }

    public final void pushMap(String anchorName, Map map) {
        this.mapStack.add(map);
        if (this.getLogger().isDebugEnabled()) {
            this.dumpParameters();
        }
        if (anchorName != null) {
            if (!this.nameToMap.containsKey(anchorName)) {
                this.nameToMap.put(anchorName, map);
                this.mapToName.put(map, anchorName);
            } else if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("name [" + anchorName + "] clashes");
            }
        }
    }

    protected void dumpParameters() {
        if (!this.mapStack.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nCurrent Sitemap Parameters:\n");
            String path = "";
            for (int i = this.mapStack.size() - 1; i >= 0; --i) {
                Map map = (Map)this.mapStack.get(i);
                sb.append("LEVEL ").append(i + 1);
                if (this.mapToName.containsKey(map)) {
                    sb.append(" is named '").append(String.valueOf(this.mapToName.get(map))).append("'");
                }
                sb.append("\n");
                Iterator keys = map.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    sb.append("PARAM: '").append(path).append(key).append("' ");
                    sb.append("VALUE: '").append(map.get(key)).append("'\n");
                }
                path = "../" + path;
            }
            this.getLogger().debug(sb.toString());
        }
    }

    public final void popMap() {
        Object map = this.mapStack.remove(this.mapStack.size() - 1);
        Object name = this.mapToName.get(map);
        this.mapToName.remove(map);
        this.nameToMap.remove(name);
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }

    public Redirector getRedirector() {
        return this.redirector;
    }

    public final void reset() {
        this.mapStack.clear();
        this.mapToName.clear();
        this.nameToMap.clear();
        this.dispose();
    }

    public void dispose() {
        if (this.internalPipelineDescription == null && this.pipelinesManager != null) {
            if (this.pipelineSelector != null) {
                this.pipelineSelector.release((Object)this.processingPipeline);
                this.processingPipeline = null;
                this.pipelinesManager.release((Object)this.pipelineSelector);
                this.pipelineSelector = null;
            }
            this.pipelinesManager = null;
            this.processingPipelineParameters = null;
        }
    }
}

