/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.sitemap.SitemapExecutor;
import org.apache.cocoon.sitemap.impl.DefaultExecutor;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.regexp.RE;
import org.xml.sax.ContentHandler;

public class TreeProcessor
extends AbstractLogEnabled
implements ThreadSafe,
Processor,
Serviceable,
Configurable,
Contextualizable,
Disposable,
Initializable {
    private static final String XCONF_URL = "resource://org/apache/cocoon/components/treeprocessor/sitemap-language.xml";
    protected TreeProcessor parent;
    protected Context context;
    protected ServiceManager manager;
    protected long lastModified = 0L;
    protected DelayedRefreshSourceWrapper source;
    protected long lastModifiedDelay;
    protected String fileName;
    protected boolean checkReload;
    protected SourceResolver resolver;
    private EnvironmentHelper environmentHelper;
    private SitemapExecutor sitemapExecutor;
    private boolean releaseSitemapExecutor;
    protected ConcreteTreeProcessor concreteProcessor;
    private Configuration treeBuilderConfiguration;

    public TreeProcessor() {
        this.checkReload = true;
        this.lastModifiedDelay = 1000L;
    }

    protected TreeProcessor(TreeProcessor parent, DelayedRefreshSourceWrapper sitemapSource, boolean checkReload, String prefix) throws Exception {
        this.parent = parent;
        this.enableLogging(parent.getLogger());
        this.context = parent.context;
        this.source = sitemapSource;
        this.treeBuilderConfiguration = parent.treeBuilderConfiguration;
        this.checkReload = checkReload;
        this.lastModifiedDelay = parent.lastModifiedDelay;
        this.manager = parent.concreteProcessor.getServiceManager();
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        this.environmentHelper = new EnvironmentHelper(parent.environmentHelper);
        ContainerUtil.enableLogging((Object)this.environmentHelper, (Logger)this.getLogger());
        ContainerUtil.service((Object)this.environmentHelper, (ServiceManager)this.manager);
        this.environmentHelper.changeContext(sitemapSource, prefix);
        this.sitemapExecutor = parent.sitemapExecutor;
    }

    public TreeProcessor createChildProcessor(String src, boolean checkReload, String prefix) throws Exception {
        DelayedRefreshSourceWrapper delayedSource = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(src), this.lastModifiedDelay);
        return new TreeProcessor(this, delayedSource, checkReload, prefix);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void initialize() throws Exception {
        if (this.environmentHelper == null) {
            this.environmentHelper = new EnvironmentHelper((String)this.context.get((Object)"root-url"));
        }
        ContainerUtil.enableLogging((Object)this.environmentHelper, (Logger)this.getLogger());
        ContainerUtil.service((Object)this.environmentHelper, (ServiceManager)this.manager);
        if (this.parent == null) {
            try {
                this.sitemapExecutor = (SitemapExecutor)this.manager.lookup(SitemapExecutor.ROLE);
                this.releaseSitemapExecutor = true;
            }
            catch (ServiceException e) {
                this.sitemapExecutor = new DefaultExecutor();
            }
        } else {
            this.sitemapExecutor = this.parent.sitemapExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) throws ConfigurationException {
        this.fileName = config.getAttribute("file", null);
        this.checkReload = config.getAttributeAsBoolean("check-reload", true);
        String xconfURL = config.getAttribute("config", XCONF_URL);
        this.lastModifiedDelay = config.getChild("reload").getAttributeAsLong("delay", 1000L);
        try {
            Source source = this.resolver.resolveURI(xconfURL);
            try {
                SAXConfigurationHandler handler = new SAXConfigurationHandler();
                SourceUtil.toSAX(this.manager, source, null, (ContentHandler)handler);
                this.treeBuilderConfiguration = handler.getConfiguration();
            }
            finally {
                this.resolver.release(source);
            }
        }
        catch (Exception e) {
            String msg = "Error while reading " + xconfURL + ": " + e.getMessage();
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    public boolean process(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.process(environment);
    }

    public Processor.InternalPipelineDescription buildPipeline(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.buildPipeline(environment);
    }

    public Processor getRootProcessor() {
        TreeProcessor result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public Configuration[] getComponentConfigurations() {
        return this.concreteProcessor.getComponentConfigurations();
    }

    public String getContext() {
        return this.environmentHelper.getContext();
    }

    public org.apache.cocoon.environment.SourceResolver getSourceResolver() {
        return this.environmentHelper;
    }

    public EnvironmentHelper getEnvironmentHelper() {
        return this.environmentHelper;
    }

    private TreeBuilder getTreeBuilder(Configuration sitemapProgram) throws ConfigurationException {
        RE re = new RE("http://apache.org/cocoon/sitemap/(\\d\\.\\d)");
        String ns = sitemapProgram.getNamespace();
        if (!re.match(ns)) {
            throw new ConfigurationException("Unknown sitemap namespace (" + ns + ") at " + this.source.getURI());
        }
        String version = re.getParen(1);
        String result = TreeBuilder.ROLE + "/sitemap-" + version;
        try {
            return (TreeBuilder)this.manager.lookup(result);
        }
        catch (Exception e) {
            throw new ConfigurationException("This version of Cocoon does not handle sitemap version " + version + " at " + this.source.getURI(), (Throwable)e);
        }
    }

    private void setupConcreteProcessor(Environment env) throws Exception {
        if (this.concreteProcessor == null || this.checkReload && this.source.getLastModified() != this.lastModified) {
            this.buildConcreteProcessor(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildConcreteProcessor(Environment env) throws Exception {
        ConcreteTreeProcessor newProcessor;
        long newLastModified;
        if (this.concreteProcessor != null && this.source.getLastModified() == this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        EnvironmentHelper.enterProcessor(this, this.manager, env);
        try {
            if (this.fileName == null) {
                this.fileName = "sitemap.xmap";
            }
            if (this.source == null) {
                this.source = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(this.fileName), this.lastModifiedDelay);
            }
            NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
            SourceUtil.toSAX(this.source, (ContentHandler)handler);
            Configuration sitemapProgram = handler.getConfiguration();
            newLastModified = this.source.getLastModified();
            newProcessor = this.createConcreteTreeProcessor();
            TreeBuilder treeBuilder = this.getTreeBuilder(sitemapProgram);
            try {
                treeBuilder.setProcessor(newProcessor);
                treeBuilder.setParentProcessorManager(this.manager);
                ProcessingNode root = treeBuilder.build(sitemapProgram);
                newProcessor.setProcessorData(treeBuilder.getBuiltProcessorManager(), root, treeBuilder.getDisposableNodes());
            }
            finally {
                this.manager.release((Object)treeBuilder);
            }
        }
        finally {
            EnvironmentHelper.leaveProcessor();
        }
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            this.getLogger().debug("TreeProcessor built in " + time + " secs from " + this.source.getURI());
        }
        ConcreteTreeProcessor oldProcessor = this.concreteProcessor;
        this.concreteProcessor = newProcessor;
        this.lastModified = newLastModified;
        if (oldProcessor != null) {
            oldProcessor.markForDisposal();
        }
    }

    private ConcreteTreeProcessor createConcreteTreeProcessor() {
        ConcreteTreeProcessor processor = new ConcreteTreeProcessor(this, this.sitemapExecutor);
        this.setupLogger(processor);
        return processor;
    }

    public void dispose() {
        ContainerUtil.dispose((Object)this.concreteProcessor);
        this.concreteProcessor = null;
        if (this.releaseSitemapExecutor) {
            this.manager.release((Object)this.sitemapExecutor);
            this.sitemapExecutor = null;
        }
        if (this.manager != null) {
            if (this.source != null) {
                this.resolver.release(this.source.getSource());
                this.source = null;
            }
            this.manager.release((Object)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }
}

