/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActSetNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActTypeNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActionSetNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActionSetNodeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;

public class ActNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements LinkedProcessingNodeBuilder {
    private ActSetNode actSetNode;
    private String actSetName;

    public ProcessingNode buildNode(Configuration config) throws Exception {
        boolean inActionSet = this.treeBuilder.getAttribute(ActionSetNodeBuilder.IN_ACTION_SET) != null;
        this.actSetName = config.getAttribute("set", null);
        if (this.actSetName == null) {
            if (inActionSet) {
                Configuration[] children = config.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    String name = children[i].getName();
                    if ("act".equals(name) || "parameter".equals(name)) continue;
                    throw new ConfigurationException("An action set can only contain actions and not '" + name + "' at " + children[i].getLocation());
                }
            }
            String name = config.getAttribute("name", null);
            String source = config.getAttribute("src", null);
            String type = this.treeBuilder.getTypeForStatement(config, Action.ROLE);
            ActTypeNode actTypeNode = new ActTypeNode(type, VariableResolverFactory.getResolver(source, this.manager), name, inActionSet);
            this.treeBuilder.setupNode(actTypeNode, config);
            actTypeNode.setChildren(this.buildChildNodes(config));
            return actTypeNode;
        }
        if (inActionSet) {
            throw new ConfigurationException("Cannot call an action set from an action set at " + config.getLocation());
        }
        if (config.getAttribute("src", null) != null) {
            this.getLogger().warn("The 'src' attribute is ignored for action-set call at " + config.getLocation());
        }
        this.actSetNode = new ActSetNode();
        this.treeBuilder.setupNode(this.actSetNode, config);
        this.actSetNode.setChildren(this.buildChildNodes(config));
        return this.actSetNode;
    }

    public void linkNode() throws Exception {
        if (this.actSetNode != null) {
            CategoryNode actionSets = CategoryNodeBuilder.getCategoryNode(this.treeBuilder, "action-sets");
            if (actionSets == null) {
                throw new ConfigurationException("This sitemap contains no action sets. Cannot call at " + this.actSetNode.getLocation());
            }
            ActionSetNode actionSetNode = (ActionSetNode)actionSets.getNodeByName(this.actSetName);
            this.actSetNode.setActionSet(actionSetNode);
        }
    }
}

